/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.ae2utilities.mixins;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.helpers.DualityInterface;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.tile.inventory.AppEngInternalInventory;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={DualityInterface.class}, remap=false)
public abstract class MixinDualityEnhancedInterface {
    @Shadow
    @Final
    private AENetworkProxy gridProxy;
    @Shadow
    private List<ICraftingPatternDetails> craftingList;
    @Shadow
    @Final
    private AppEngInternalInventory patterns;

    @Shadow
    public abstract IItemHandler getPatterns();

    @Shadow
    protected abstract void addToCraftingList(ItemStack var1);

    @Overwrite
    private void updateCraftingList() {
        boolean[] accountedFor = new boolean[this.patterns.getSlots()];
        assert (accountedFor.length == this.getPatterns().getSlots());
        if (!this.gridProxy.isReady()) {
            return;
        }
        if (this.craftingList != null) {
            Iterator<ICraftingPatternDetails> i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.getPatterns().getStackInSlot(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (accountedFor[x]) continue;
            this.addToCraftingList(this.getPatterns().getStackInSlot(x));
        }
        try {
            this.gridProxy.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.gridProxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }
}

