/*
 * Decompiled with CFR 0.152.
 */
package one.flexo.nibbler.item;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import one.flexo.nibbler.INibble;
import one.flexo.nibbler.item.NibblerItem;

public class NibblerEnumItem<T extends Enum<T>>
extends NibblerItem {
    final Class<T> enumType;
    final T[] types;

    public NibblerEnumItem(String modid, String name, Class<T> enumType) {
        this(modid, name, enumType, null);
    }

    public NibblerEnumItem(String modid, String name, Class<T> enumType, CreativeTabs creativeTab) {
        super(modid, name, creativeTab);
        this.enumType = enumType;
        this.types = (Enum[])enumType.getEnumConstants();
        this.func_77627_a(true);
        this.nibble().withMeta(meta -> meta < 0 || meta >= this.types.length ? "unknown" : ((Enum)this.types[meta]).name());
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < this.types.length; ++i) {
                stacks.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta < 0 || meta >= this.types.length) {
            return "unknown";
        }
        return "item." + ((INibble)this.types[meta]).nibble().getUnlocalizedName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < this.types.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation(((INibble)this.types[i]).nibble().toString(), "inventory"));
        }
    }
}

