/*
 * Decompiled with CFR 0.152.
 */
package one.flexo.nibbler.item.tool;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class NibblerToolData {
    public final float damage;
    public final float speed;
    public final Item.ToolMaterial material;
    public final Set<Block> effectiveBlocks;

    public NibblerToolData(float damage, float speed) {
        this(damage, speed, Item.ToolMaterial.WOOD, Collections.emptySet());
    }

    public NibblerToolData(float damage, float speed, Item.ToolMaterial material) {
        this(damage, speed, material, Collections.emptySet());
    }

    public NibblerToolData(float damage, float speed, Item.ToolMaterial material, Set<Block> effectiveBlocks) {
        this.damage = damage;
        this.speed = speed;
        this.material = material;
        this.effectiveBlocks = effectiveBlocks;
    }

    public NibblerToolData as(Item.ToolMaterial newMaterial) {
        return new NibblerToolData(this.damage, this.speed, newMaterial, this.effectiveBlocks);
    }

    public NibblerToolData as(Item.ToolMaterial newMaterial, Block ... addedEffectiveBlocks) {
        HashSet newEffectiveBlocks = Sets.newHashSet((Object[])addedEffectiveBlocks);
        newEffectiveBlocks.addAll(this.effectiveBlocks);
        return new NibblerToolData(this.damage, this.speed, newMaterial, newEffectiveBlocks);
    }

    public NibblerToolData add(Block ... addedEffectiveBlocks) {
        HashSet newEffectiveBlocks = Sets.newHashSet((Object[])addedEffectiveBlocks);
        newEffectiveBlocks.addAll(this.effectiveBlocks);
        return new NibblerToolData(this.damage, this.speed, this.material, newEffectiveBlocks);
    }
}

