/*
 * Decompiled with CFR 0.152.
 */
package one.flexo.nibbler.proxy;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;
import one.flexo.nibbler.Nibbler;

@Mod.EventBusSubscriber
public abstract class CommonProxy {
    public static Configuration config;
    private static final Map<ItemStack, String> oreReplacements;

    public void preInit(FMLPreInitializationEvent e) {
    }

    public void init(FMLInitializationEvent e) {
    }

    public void postInit(FMLPostInitializationEvent e) {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Nibbler.registry.registerBlocks(event);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Nibbler.registry.registerItems(event);
        CommonProxy.initOreRegistry();
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (Map.Entry<ItemStack, String> entry : oreReplacements.entrySet()) {
            ItemStack itemStack = entry.getKey();
            String oreName = entry.getValue();
            OreIngredient oreIngredient = new OreIngredient(oreName);
            IForgeRegistry registry = event.getRegistry();
            for (IRecipe recipe : registry.getValues()) {
                NonNullList ingredients = recipe.func_192400_c();
                for (int i = 0; i < ingredients.size(); ++i) {
                    if (ingredients.get(i) instanceof OreIngredient || !((Ingredient)ingredients.get(i)).test((Object)itemStack)) continue;
                    ingredients.set(i, (Object)oreIngredient);
                }
            }
        }
    }

    public static void initOreRegistry() {
        OreDictionary.registerOre((String)"book", (Item)Items.field_151122_aG);
        oreReplacements.put(new ItemStack(Items.field_151122_aG), "book");
    }

    static {
        oreReplacements = new HashMap<ItemStack, String>();
    }
}

