/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.api.upgrades;

import com.enderio.core.common.MappedCapabilityProvider;
import com.enderio.core.common.interfaces.INotDestroyedInItemFrames;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IEquipmentData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;

public interface IDarkSteelItem
extends INotDestroyedInItemFrames {
    default public int getIngotsRequiredForFullRepair() {
        return 9;
    }

    default public boolean isItemForRepair(@Nonnull ItemStack right) {
        return false;
    }

    default public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return false;
    }

    default public boolean isWeapon() {
        return this instanceof ItemSword || this.isAxe();
    }

    default public boolean isBlockBreakingTool() {
        return this.isPickaxe() || this.isAxe();
    }

    default public boolean isPickaxe() {
        return false;
    }

    default public boolean isAxe() {
        return false;
    }

    default public boolean hasUpgradeCallbacks(@Nonnull IDarkSteelUpgrade upgrade) {
        return false;
    }

    @Nonnull
    public IEquipmentData getEquipmentData();

    @Nonnull
    public ICapacitorKey getEnergyStorageKey(@Nonnull ItemStack var1);

    @Nonnull
    public ICapacitorKey getEnergyInputKey(@Nonnull ItemStack var1);

    @Nonnull
    public ICapacitorKey getEnergyUseKey(@Nonnull ItemStack var1);

    default public boolean allowExtractEnergy() {
        return false;
    }

    @Nonnull
    public ICapacitorKey getAbsorptionRatioKey(@Nonnull ItemStack var1);

    default public int getMaxEmpoweredLevel(@Nonnull ItemStack stack) {
        return this.getEquipmentData().getTier() >= 2 ? 4 : 3;
    }

    @Nonnull
    default public MappedCapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt, @Nonnull MappedCapabilityProvider capProv) {
        return capProv;
    }

    default public void openUpgradeGui(@Nonnull EntityPlayer player, @Nullable EntityEquipmentSlot slot) {
    }

    default public void openUpgradeGui(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        this.openUpgradeGui(player, hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND);
    }

    default public boolean canUpgradeBeRemoved(@Nonnull ItemStack stack, @Nullable IDarkSteelUpgrade upgrade) {
        return true;
    }
}

