/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.holy;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.base.render.IDefaultRenderers;
import crazypants.enderio.base.render.ranged.InfinityParticle;
import crazypants.enderio.util.NNPair;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialTransparent;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockHolyBase
extends BlockEio<TileEntityEio>
implements IDefaultRenderers,
IResourceTooltipProvider {
    private long nextTick = 0L;
    private int countPerTick = 0;

    @SideOnly(value=Side.CLIENT)
    protected static void makeParticle(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rnd) {
        float offsetX = 0.25f + 0.5f * rnd.nextFloat();
        float offsetY = 0.25f + 0.5f * rnd.nextFloat();
        float offsetZ = 0.25f + 0.5f * rnd.nextFloat();
        float maxSize = Math.min(Math.min(Math.min(1.0f - offsetX, offsetX), Math.min(1.0f - offsetY, offsetY)), Math.min(1.0f - offsetZ, offsetZ)) * (0.5f + 0.5f * rnd.nextFloat()) / 4.0f;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new InfinityParticle(world, pos, new Vector4f(0.99215686f, 1.0f, 0.0f, 0.4f), new Vector4f(offsetX, offsetY, offsetZ, maxSize)));
    }

    public BlockHolyBase(@Nonnull IModObject modObject) {
        super(modObject, (Material)new MaterialTransparent(MapColor.field_151660_b));
        this.func_149647_a(EnderIOTab.tabEnderIOMaterials);
        this.func_149672_a(new SoundType(-1.0f, 1.0f, SoundEvents.field_187546_ae, SoundEvents.field_187554_ai, SoundEvents.field_187552_ah, SoundEvents.field_187550_ag, SoundEvents.field_187548_af));
        this.initDefaultState();
        this.setShape(this.mkShape(BlockFaceShape.UNDEFINED));
        this.func_149715_a(1.0f);
        this.func_149675_a(true);
    }

    protected abstract void setQuanta(@Nonnull World var1, @Nonnull BlockPos var2, int var3, int var4);

    protected abstract void initDefaultState();

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockStateIn, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_176209_a(@Nonnull IBlockState state, boolean hitIfLiquid) {
        return false;
    }

    public void func_180653_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
    }

    public boolean func_176200_f(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return true;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean isAir(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    public void onBlockPlaced(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull ItemStack stack) {
        if (!world.field_72995_K) {
            world.func_180497_b(pos, (Block)this, 5, 0);
        } else {
            for (int i = 0; i < 5; ++i) {
                BlockHolyBase.makeParticle(world, pos, world.field_73012_v);
            }
        }
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        if (!world.field_72995_K) {
            world.func_180497_b(pos, (Block)this, 5, 0);
        }
    }

    protected abstract int getQuanta(@Nonnull World var1, @Nonnull BlockPos var2, @Nonnull IBlockState var3);

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rnd) {
        if (!world.field_72995_K) {
            int extraQuanta;
            long currentTick = EnderIO.proxy.getServerTickCount();
            if (currentTick % 5L != 0L) {
                world.func_180497_b(pos, (Block)this, (int)(5L - currentTick % 5L), -1);
                return;
            }
            if (this.nextTick <= currentTick) {
                this.nextTick = currentTick + 1L;
                this.countPerTick = 0;
            }
            if (this.countPerTick > 40) {
                world.func_180497_b(pos, (Block)this, 5, -2);
                return;
            }
            int ourQuanta = this.getQuanta(world, pos, state);
            IBlockState down = world.func_180495_p(pos.func_177977_b());
            if (down.func_177230_c() == Blocks.field_150350_a) {
                this.setQuanta(world, pos, 0, 0);
                this.setQuanta(world, pos.func_177977_b(), ourQuanta, 5);
                ++this.countPerTick;
                return;
            }
            if (down.func_185904_a().func_76224_d()) {
                this.setQuanta(world, pos, 0, 0);
                ++this.countPerTick;
                return;
            }
            int downQuanta = this.getQuanta(world, pos.func_177977_b(), down);
            if (downQuanta > 0 && downQuanta < this.getMaxQuanta()) {
                if ((downQuanta += ourQuanta) <= this.getMaxQuanta()) {
                    this.setQuanta(world, pos, 0, 0);
                    this.setQuanta(world, pos.func_177977_b(), downQuanta, 5);
                } else {
                    int myQuanta = downQuanta - this.getMaxQuanta();
                    downQuanta = this.getMaxQuanta();
                    this.setQuanta(world, pos, myQuanta, 6);
                    this.setQuanta(world, pos.func_177977_b(), downQuanta, 5);
                }
                ++this.countPerTick;
                return;
            }
            int totalQuanta = ourQuanta;
            boolean nearWater = false;
            NNList list = new NNList();
            NNList.NNIterator itr = NNList.FACING_HORIZONTAL.fastIterator();
            while (itr.hasNext()) {
                EnumFacing facing = (EnumFacing)itr.next();
                BlockPos neighborPos = pos.func_177972_a(facing);
                if (!world.func_175667_e(neighborPos)) continue;
                IBlockState neighbor = world.func_180495_p(neighborPos);
                if (neighbor.func_177230_c() == Blocks.field_150350_a) {
                    list.add(NNPair.of(neighborPos, neighbor));
                    continue;
                }
                int neighborQuanta = this.getQuanta(world, neighborPos, neighbor);
                if (neighborQuanta > 0) {
                    totalQuanta += neighborQuanta;
                    list.add(NNPair.of(neighborPos, neighbor));
                    continue;
                }
                if (!neighbor.func_185904_a().func_76224_d()) continue;
                nearWater = true;
            }
            if (!nearWater && list.isEmpty()) {
                return;
            }
            if (nearWater) {
                totalQuanta /= 2;
            }
            list.add(0, NNPair.of(pos, state));
            int quantaPerBlock = totalQuanta / list.size();
            if (totalQuanta > 0 && quantaPerBlock == 0) {
                NNList.NNIterator itr2 = list.iterator();
                while (itr2.hasNext()) {
                    NNPair next = (NNPair)((Object)itr2.next());
                    if (((IBlockState)next.getValue()).func_177230_c() != Blocks.field_150350_a) continue;
                    itr2.remove();
                    quantaPerBlock = totalQuanta / list.size();
                    if (quantaPerBlock <= 0) continue;
                    break;
                }
            }
            if ((extraQuanta = totalQuanta - quantaPerBlock * list.size()) > 0) {
                NNList.NNIterator itr3 = list.iterator();
                while (itr3.hasNext()) {
                    NNPair next = (NNPair)((Object)itr3.next());
                    if (this.getQuanta(world, (BlockPos)next.getLeft(), (IBlockState)next.getValue()) != quantaPerBlock + 1) continue;
                    itr3.remove();
                    if (--extraQuanta != 0) continue;
                    break;
                }
            }
            boolean hasUpdated = false;
            for (NNPair next : list) {
                int q = quantaPerBlock;
                if (extraQuanta > 0) {
                    ++q;
                    --extraQuanta;
                }
                BlockPos target = (BlockPos)next.getKey();
                if (this.getQuanta(world, (BlockPos)next.getLeft(), (IBlockState)next.getValue()) == q) continue;
                this.setQuanta(world, target, q, 5);
                hasUpdated = true;
            }
            if (hasUpdated) {
                ++this.countPerTick;
            }
        }
    }

    protected abstract int getMaxQuanta();

    public void func_180634_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entityIn) {
        if (!world.field_72995_K && entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_70668_bt() == EnumCreatureAttribute.UNDEAD && world.field_73012_v.nextFloat() < 0.05f) {
            entityIn.func_70097_a(DamageSource.field_190095_e, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random random) {
        int quanta = this.getQuanta(world, pos, bs) + (Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() == ModObjectRegistry.getItem(ModObjectRegistry.getModObjectNN((Block)this)) ? 20 : 0);
        float f = random.nextFloat();
        float f2 = quanta >= this.getMaxQuanta() ? 1.0f : (quanta > 10 ? 0.01f : 0.001f);
        if (f < f2 * (float)quanta) {
            BlockHolyBase.makeParticle(world, pos, random);
        }
    }

    public BlockHolyBase(@Nonnull IModObject modObject, @Nonnull Material mat, MapColor mapColor) {
        super(modObject, mat, mapColor);
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return this.func_149739_a();
    }

    public void func_180645_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random random) {
        if (world.func_175727_C(pos) && random.nextFloat() < 0.1f) {
            this.setQuanta(world, pos, (int)((float)this.getQuanta(world, pos, state) * random.nextFloat()), 0);
        }
    }

    public void func_176224_k(@Nonnull World world, @Nonnull BlockPos pos) {
    }
}

