/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.painted;

import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.block.painted.TileEntityTwicePaintedBlock;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.paint.render.PaintHelper;
import crazypants.enderio.base.paint.render.PaintRegistry;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.ICacheKey;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumRenderPart;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.base.render.util.QuadCollector;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.NotImplementedException;

public abstract class BlockPaintedSlab
extends BlockSlab
implements ITileEntityProvider,
IPaintable.ITexturePaintableBlock,
ISmartRenderAwareBlock,
IRenderMapper.IBlockRenderMapper.IRenderLayerAware,
IRenderMapper.IItemRenderMapper.IItemModelMapper {
    @Nonnull
    private final Block halfVariant;

    public BlockPaintedSlab(@Nonnull IModObject modObject, @Nonnull Material material, @Nullable Block halfVariant) {
        super(material);
        IBlockState iblockstate = this.func_176194_O().func_177621_b();
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(iblockstate);
        Prep.setNoCreativeTab((Block)this);
        this.halfVariant = halfVariant != null ? halfVariant : this;
        this.field_149783_u = true;
        modObject.apply(this);
    }

    protected void init(@Nonnull IModObject modObject) {
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel("slab_lo", new ResourceLocation("minecraft", "block/half_slab_stone"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("slab_hi", new ResourceLocation("minecraft", "block/upper_slab_stone"), PaintRegistry.PaintMode.ALL_TEXTURES);
    }

    @Nonnull
    public Comparable<?> func_185674_a(@Nonnull ItemStack stack) {
        throw new NotImplementedException("This method is only used by ItemSlab for vanilla slabs.");
    }

    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityTwicePaintedBlock();
    }

    @Nonnull
    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PaintUtil.getSourceBlock(stack));
        if (!world.field_72995_K) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(bs, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World worldIn, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, @Nonnull ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        super.removedByPlayer(state, worldIn, pos, player, true);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        NNList drops2 = new NNList();
        super.getDrops((NonNullList)drops2, world, pos, state, fortune);
        boolean first = true;
        for (ItemStack drop : drops2) {
            if (first || !this.func_176552_j()) {
                PaintUtil.setSourceBlock((ItemStack)NullHelper.notnullM((Object)drop, (String)"null stack from getDrops()"), this.getPaintSource(state, world, pos));
                first = false;
                continue;
            }
            PaintUtil.setSourceBlock((ItemStack)NullHelper.notnullM((Object)drop, (String)"null stack from getDrops()"), this.getPaintSource2(state, world, pos));
        }
        drops.addAll((Collection)drops2);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState bs, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(bs, target, world, pos, player);
        if (!this.func_176552_j()) {
            PaintUtil.setSourceBlock(pickBlock, this.getPaintSource(bs, (IBlockAccess)world, pos));
        } else if (target.field_72307_f.field_72448_b - (double)((int)target.field_72307_f.field_72448_b) > 0.5) {
            PaintUtil.setSourceBlock(pickBlock, this.getPaintSource2(bs, (IBlockAccess)world, pos));
        } else {
            PaintUtil.setSourceBlock(pickBlock, this.getPaintSource(bs, (IBlockAccess)world, pos));
        }
        return pickBlock;
    }

    @Nonnull
    public Item func_180660_a(@Nonnull IBlockState state, @Nonnull Random rand, int fortune) {
        return Item.func_150898_a((Block)this.halfVariant);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ItemStack func_185473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this.halfVariant));
    }

    @Nonnull
    public IProperty<?> func_176551_l() {
        throw new RuntimeException("no such property");
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (this.func_176552_j()) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        if (this.func_176552_j()) {
            return 0;
        }
        return state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? 8 : 0;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[0]) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a});
    }

    public void setPaintSource2(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTwicePaintedBlock) {
            ((TileEntityTwicePaintedBlock)te).setPaintSource2(paintSource);
        }
    }

    public IBlockState getPaintSource2(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (this.func_176552_j()) {
            TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
            if (te instanceof TileEntityTwicePaintedBlock) {
                return ((TileEntityTwicePaintedBlock)te).getPaintSource2();
            }
            return null;
        }
        return this.getPaintSource(state, world, pos);
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, this);
        if (this.func_176552_j()) {
            blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(this.getPaintSource2(state, world, pos));
        } else {
            blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(state.func_177229_b((IProperty)field_176554_a));
        }
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey.addCacheKey(this.getPaintSource(block, stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBakedModel> mapItemRender(@Nonnull Block block, @Nonnull ItemStack stack) {
        IBlockState paintSource = this.getPaintSource(block, stack);
        IBlockState stdOverlay = ModObject.block_machine_base.getBlockNN().func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY));
        IBakedModel model1 = PaintRegistry.getModel(IBakedModel.class, "slab_lo", paintSource, null);
        IBakedModel model2 = PaintRegistry.getModel(IBakedModel.class, "slab_lo", stdOverlay, PaintRegistry.OVERLAY_TRANSFORMATION3);
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        list.add(model1);
        list.add(model2);
        return list;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    public int getFlammability(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        IBlockState bs = world.func_180495_p(pos);
        return bs.func_185904_a() == Material.field_151575_d ? 20 : super.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151575_d ? 5 : super.getFireSpreadSpeed(world, pos, face);
    }

    public boolean doesSideBlockRendering(@Nonnull IBlockState bs, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return false;
    }

    public boolean func_176225_a(@Nonnull IBlockState ourBlockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos here, @Nonnull EnumFacing side) {
        BlockPos there = here.func_177972_a(side);
        IBlockState blockState2 = worldIn.func_180495_p(there);
        Block block2 = blockState2.func_177230_c();
        if (block2 instanceof BlockPaintedSlab) {
            BlockPaintedSlab otherBlock = (BlockPaintedSlab)block2;
            if (side == EnumFacing.UP) {
                if (!this.func_176552_j() && ourBlockState.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM) {
                    return true;
                }
                if (!otherBlock.func_176552_j() && blockState2.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                    return true;
                }
                IBlockState ourPaint = this.func_176552_j() ? this.getPaintSource2(ourBlockState, worldIn, here) : this.getPaintSource(ourBlockState, worldIn, here);
                IBlockState otherPaint = this.getPaintSource(blockState2, worldIn, there);
                return ourPaint != otherPaint;
            }
            if (side == EnumFacing.DOWN) {
                if (!this.func_176552_j() && ourBlockState.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                    return true;
                }
                if (!otherBlock.func_176552_j() && blockState2.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM) {
                    return true;
                }
                IBlockState ourPaint = this.getPaintSource(ourBlockState, worldIn, here);
                IBlockState otherPaint = otherBlock.func_176552_j() ? this.getPaintSource2(blockState2, worldIn, there) : this.getPaintSource(blockState2, worldIn, there);
                return ourPaint != otherPaint;
            }
            if (this.func_176552_j()) {
                if (!otherBlock.func_176552_j()) {
                    return true;
                }
                return this.getPaintSource(ourBlockState, worldIn, here) != this.getPaintSource(blockState2, worldIn, there) || this.getPaintSource2(ourBlockState, worldIn, here) != this.getPaintSource2(blockState2, worldIn, there);
            }
            if (!otherBlock.func_176552_j() && blockState2.func_177229_b((IProperty)field_176554_a) != ourBlockState.func_177229_b((IProperty)field_176554_a)) {
                return true;
            }
            IBlockState paintSource = this.getPaintSource(ourBlockState, worldIn, here);
            if (otherBlock.func_176552_j() && ourBlockState.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                return paintSource != this.getPaintSource2(blockState2, worldIn, there);
            }
            return paintSource != this.getPaintSource(blockState2, worldIn, there);
        }
        return super.func_176225_a(ourBlockState, worldIn, here, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, BlockRenderLayer blockLayer, @Nonnull QuadCollector quadCollector) {
        for (BlockSlab.EnumBlockHalf half : BlockSlab.EnumBlockHalf.values()) {
            IBlockState paintSource;
            if (!this.func_176552_j() && half != state.func_177229_b((IProperty)field_176554_a)) continue;
            boolean isTop = half == BlockSlab.EnumBlockHalf.TOP;
            IBlockState iBlockState = paintSource = isTop ? this.getPaintSource2(state, world, pos) : this.getPaintSource(state, world, pos);
            if (blockLayer != null && !PaintUtil.canRenderInLayer(paintSource, blockLayer)) continue;
            quadCollector.addFriendlybakedModel(blockLayer, PaintRegistry.getModel(IBakedModel.class, isTop ? "slab_hi" : "slab_lo", paintSource, null), paintSource, MathHelper.func_180186_a((Vec3i)pos));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }

    public static class BlockPaintedDoubleSlab
    extends BlockPaintedSlab {
        public BlockPaintedDoubleSlab(@Nonnull IModObject modObject, @Nonnull Material material, Block halfVariant, @Nonnull SoundType sound) {
            super(modObject, material, halfVariant);
            this.func_149672_a(sound);
        }

        public boolean func_176552_j() {
            return true;
        }
    }

    public static class BlockPaintedHalfSlab
    extends BlockPaintedSlab {
        public BlockPaintedHalfSlab(@Nonnull IModObject modObject, @Nonnull Material material, @Nonnull SoundType sound) {
            super(modObject, material, null);
            this.func_149672_a(sound);
        }

        public boolean func_176552_j() {
            return false;
        }
    }
}

