/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capability;

import com.enderio.core.common.inventory.Filters;
import com.google.common.base.Predicate;
import crazypants.enderio.base.capacitor.CapacitorHelper;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import crazypants.enderio.util.CapturedMob;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Filters {
    @Nonnull
    public static final Predicate<ItemStack> PAINTABLE = new Filters.PredicateItemStack(){

        public boolean doApply(@Nonnull ItemStack input) {
            return Block.func_149634_a((Item)input.func_77973_b()) instanceof IPaintable;
        }
    };
    @Nonnull
    public static final Predicate<ItemStack> SOUL_VIALS = new Filters.PredicateItemStack(){

        public boolean doApply(@Nonnull ItemStack input) {
            return input.func_77973_b() == ModObject.itemSoulVial.getItemNN();
        }
    };
    @Nonnull
    public static final Predicate<ItemStack> WITH_MOB_SOUL = new Filters.PredicateItemStack(){

        public boolean doApply(@Nonnull ItemStack input) {
            return CapturedMob.containsSoul(input);
        }
    };
    @Nonnull
    public static final Predicate<ItemStack> FILLED_SOUL_VIALS = com.enderio.core.common.inventory.Filters.and(SOUL_VIALS, WITH_MOB_SOUL);
    @Nonnull
    public static final Predicate<ItemStack> EMPTY_SOUL_VIALS = com.enderio.core.common.inventory.Filters.and(SOUL_VIALS, (Predicate)com.enderio.core.common.inventory.Filters.not(WITH_MOB_SOUL));
    @Nonnull
    public static final Predicate<ItemStack> GRINDING_BALLS = new Filters.PredicateItemStack(){

        public boolean doApply(@Nonnull ItemStack input) {
            return SagMillRecipeManager.getInstance().isValidSagBall(input);
        }
    };
    @Nonnull
    public static final Predicate<ItemStack> CAPACITORS = new Filters.PredicateItemStack(){

        public boolean doApply(@Nonnull ItemStack input) {
            return input.func_77973_b() == ModObject.itemBasicCapacitor.getItemNN() || CapacitorHelper.getCapacitorDataFromItemStack(input) != null;
        }
    };
}

