/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.base.block;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.Util;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.gui.handler.IEioGuiHandler;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.machine.entity.EntityFallingMachine;
import crazypants.enderio.base.machine.interfaces.IClearableConfiguration;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.machine.render.RenderMappers;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.render.PaintHelper;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumRenderMode;
import crazypants.enderio.base.render.property.IOMode;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import info.loenwind.autoconfig.factory.IValue;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractMachineBlock<T extends AbstractMachineEntity>
extends BlockEio<T>
implements IEioGuiHandler.WithPos,
IResourceTooltipProvider,
ISmartRenderAwareBlock,
IClearableConfiguration {
    @Nonnull
    protected final Random random;
    protected boolean isEnhanced = false;
    protected IValue<Boolean> respectsGravity = () -> false;

    protected AbstractMachineBlock(@Nonnull IModObject mo, @Nonnull Material mat) {
        super(mo, mat);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
        this.random = new Random();
        this.initDefaultState();
    }

    protected void initDefaultState() {
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)));
    }

    protected AbstractMachineBlock(@Nonnull IModObject mo) {
        this(mo, new Material(MapColor.field_151668_h));
    }

    @Override
    protected void init() {
        super.init();
        this.registerInSmartModelAttacher();
    }

    protected void registerInSmartModelAttacher() {
        SmartModelAttacher.register((Block)this);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return this.func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public final IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        BlockStateWrapperBase blockStateWrapper = this.createBlockStateWrapper(state, world, pos);
        AbstractMachineEntity tileEntity = (AbstractMachineEntity)this.getTileEntitySafe(world, pos);
        if (tileEntity != null) {
            this.setBlockStateWrapperCache(blockStateWrapper, world, pos, tileEntity);
        }
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    protected abstract void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper var1, @Nonnull IBlockAccess var2, @Nonnull BlockPos var3, @Nonnull T var4);

    @Nonnull
    protected BlockStateWrapperBase createBlockStateWrapper(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return new BlockStateWrapperBase(state, world, pos, this.getBlockRenderMapper());
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean canSilkHarvest(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player) {
        return false;
    }

    public void onBlockPlaced(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull T te) {
        ((AbstractMachineEntity)te).setFacing(this.getFacingForHeading(player));
        if (player instanceof EntityPlayer && !world.field_72995_K) {
            ((AbstractMachineEntity)te).setOwner((EntityPlayer)player);
        }
        if (world.field_72995_K) {
            return;
        }
        world.func_184138_a(pos, state, state, 3);
        Block block = this.getEnhancedExtensionBlock();
        if (this.isEnhanced && block != null) {
            world.func_175656_a(pos.func_177984_a(), block.func_176223_P());
        }
    }

    @Nonnull
    protected EnumFacing getFacingForHeading(@Nonnull EntityLivingBase player) {
        return Util.getFacingFromEntity((EntityLivingBase)player);
    }

    public void func_176213_c(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_184138_a(pos, state, state, 3);
        if (((Boolean)this.respectsGravity.get()).booleanValue()) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        AbstractMachineEntity te = (AbstractMachineEntity)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (te != null) {
            te.onNeighborBlockChange(state, worldIn, pos, blockIn, fromPos);
        }
        Block block = this.getEnhancedExtensionBlock();
        if (this.isEnhanced && block != null && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != block) {
            if (super.func_176196_c(worldIn, pos.func_177984_a())) {
                worldIn.func_175656_a(pos.func_177984_a(), block.func_176223_P());
            } else {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
                return;
            }
        }
        if (((Boolean)this.respectsGravity.get()).booleanValue()) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (((Boolean)PersonalConfig.machineParticlesEnabled.get()).booleanValue() && this.isActive((IBlockAccess)world, pos)) {
            float startX = (float)pos.func_177958_n() + 1.0f;
            float startY = (float)pos.func_177956_o() + 1.0f;
            float startZ = (float)pos.func_177952_p() + 1.0f;
            for (int i = 0; i < 4; ++i) {
                float xOffset = -0.2f - rand.nextFloat() * 0.6f;
                float yOffset = -0.1f + rand.nextFloat() * 0.2f;
                float zOffset = -0.2f - rand.nextFloat() * 0.6f;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(startX + xOffset), (double)(startY + yOffset), (double)(startZ + zOffset), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    protected boolean isActive(@Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos) {
        AbstractMachineEntity te = (AbstractMachineEntity)this.getTileEntitySafe(blockAccess, pos);
        if (te != null) {
            return te.isActive();
        }
        return false;
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack stack) {
        return this.func_149739_a();
    }

    @SideOnly(value=Side.CLIENT)
    public IOMode.EnumIOMode mapIOMode(IoMode mode, EnumFacing side) {
        switch (mode) {
            case NONE: {
                return IOMode.EnumIOMode.NONE;
            }
            case PULL: {
                return IOMode.EnumIOMode.PULL;
            }
            case PUSH: {
                return IOMode.EnumIOMode.PUSH;
            }
            case PUSH_PULL: {
                return IOMode.EnumIOMode.PUSHPULL;
            }
            case DISABLED: {
                return IOMode.EnumIOMode.DISABLED;
            }
        }
        throw new RuntimeException("Hey, leave our enums alone!");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.BODY_MAPPER;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.BODY_MAPPER;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return this instanceof IPaintable ? true : super.canRenderInLayer(state, layer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        AbstractMachineEntity te = (AbstractMachineEntity)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return this.getServerGuiElement(player, world, pos, facing, param1, te);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        AbstractMachineEntity te = (AbstractMachineEntity)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return this.getClientGuiElement(player, world, pos, facing, param1, te);
        }
        return null;
    }

    @Nullable
    public abstract Container getServerGuiElement(@Nonnull EntityPlayer var1, @Nonnull World var2, @Nonnull BlockPos var3, @Nullable EnumFacing var4, int var5, @Nonnull T var6);

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public abstract GuiScreen getClientGuiElement(@Nonnull EntityPlayer var1, @Nonnull World var2, @Nonnull BlockPos var3, @Nullable EnumFacing var4, int var5, @Nonnull T var6);

    @Nonnull
    protected final BlockEnder.IShape<T> mkShape(final @Nonnull BlockFaceShape down, final @Nonnull BlockFaceShape up, final @Nonnull BlockFaceShape front, final @Nonnull BlockFaceShape allSides) {
        return new BlockEnder.IShape<T>(){

            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face, @Nonnull T te) {
                IBlockState paintSource = ((TileEntityEio)((Object)te)).getPaintSource();
                if (paintSource != null) {
                    try {
                        return paintSource.func_193401_d(worldIn, pos, face);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return face == ((AbstractMachineEntity)te).getFacing() ? front : super.getBlockFaceShape(worldIn, state, pos, face, te);
            }

            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
                return face == EnumFacing.UP ? up : (face == EnumFacing.DOWN ? down : allSides);
            }
        };
    }

    public boolean canConnectRedstone(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        return true;
    }

    public boolean func_176196_c(@Nonnull World world, @Nonnull BlockPos pos) {
        return super.func_176196_c(world, pos) && (!this.isEnhanced || pos.func_177956_o() < 255 && super.func_176196_c(world, pos.func_177984_a()));
    }

    @Nullable
    public Block getEnhancedExtensionBlock() {
        return null;
    }

    protected void checkFallable(@Nonnull WorldServer worldIn, @Nonnull BlockPos pos) {
        if ((worldIn.func_175623_d(pos.func_177977_b()) || BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            worldIn.func_72838_d((Entity)new EntityFallingMachine(worldIn, pos, (Block)this));
        }
    }

    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)this.respectsGravity.get()).booleanValue()) {
            this.checkFallable((WorldServer)worldIn, pos);
        }
    }
}

