/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.transceiver;

import com.enderio.core.common.network.NetworkUtil;
import com.enderio.core.common.util.UserIdent;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.transceiver.Channel;
import crazypants.enderio.base.transceiver.ClientChannelRegister;
import crazypants.enderio.base.transceiver.ServerChannelRegister;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketAddRemoveChannel
implements IMessage {
    private boolean isAdd;
    private Channel channel;

    public PacketAddRemoveChannel() {
    }

    public PacketAddRemoveChannel(Channel channel, boolean isAdd) {
        this.channel = channel;
        this.isAdd = isAdd;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isAdd);
        NBTTagCompound nbt = new NBTTagCompound();
        this.channel.writeToNBT(nbt);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)nbt, (ByteBuf)buf);
    }

    public void fromBytes(ByteBuf buf) {
        this.isAdd = buf.readBoolean();
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.channel = Channel.readFromNBT(tag);
    }

    public static class Handler
    implements IMessageHandler<PacketAddRemoveChannel, IMessage> {
        public IMessage onMessage(PacketAddRemoveChannel message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                if (!message.channel.getUser().equals((UserIdent)UserIdent.NOBODY) && !message.channel.getUser().equals(ctx.getServerHandler().field_147369_b.func_146103_bH())) {
                    ctx.getServerHandler().field_147369_b.field_71135_a.func_194028_b((ITextComponent)new TextComponentString("Don't mess with other players' channels, you cheat."));
                    return null;
                }
                if (message.isAdd) {
                    ServerChannelRegister.instance.addChannel(message.channel);
                } else {
                    ServerChannelRegister.instance.removeChannel(message.channel);
                }
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketAddRemoveChannel(message.channel, message.isAdd));
            } else if (message.isAdd) {
                ClientChannelRegister.instance.addChannel(message.channel);
            } else {
                ClientChannelRegister.instance.removeChannel(message.channel);
            }
            return null;
        }
    }
}

