/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.network;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.conduits.conduit.TileConduitBundle;
import crazypants.enderio.conduits.gui.ExternalConnectionContainer;
import crazypants.enderio.conduits.network.AbstractConduitBundlePacket;
import crazypants.enderio.util.EnumReader;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class AbstractConduitPacket<T extends IConduit>
extends AbstractConduitBundlePacket {
    private UUID uuid;

    public AbstractConduitPacket() {
    }

    public AbstractConduitPacket(@Nonnull T conduit) {
        super(conduit.getBundle().getEntity());
        this.uuid = ConduitRegistry.getNetwork(conduit).getUUID();
    }

    protected Class<? extends IConduit> getConType() {
        return ConduitRegistry.getNetwork(this.uuid).getBaseType();
    }

    public void write(@Nonnull ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
    }

    public void read(@Nonnull ByteBuf buf) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
    }

    @Nullable
    public T getConduit(MessageContext ctx) {
        World world;
        TileEntity tileEntity;
        if (ctx.side == Side.SERVER) {
            if (ctx.getServerHandler().field_147369_b.field_71070_bA instanceof ExternalConnectionContainer) {
                TileConduitBundle tileEntity2 = (TileConduitBundle)((ExternalConnectionContainer)ctx.getServerHandler().field_147369_b.field_71070_bA).getTileEntity();
                if (tileEntity2 == null || !tileEntity2.func_174877_v().equals((Object)this.getPos())) {
                    Log.warn("Player " + ctx.getServerHandler().field_147369_b.func_70005_c_() + " tried to manipulate conduit while having another conduit's GUI open!");
                    return null;
                }
            } else if (BlockCoord.get((Entity)ctx.getServerHandler().field_147369_b).func_177951_i((Vec3i)this.getPos()) > EnderIO.proxy.getReachDistanceForPlayer((EntityPlayer)ctx.getServerHandler().field_147369_b)) {
                Log.warn("Player " + ctx.getServerHandler().field_147369_b.func_70005_c_() + " tried to manipulate conduit without having its GUI open or being near it!");
                return null;
            }
        }
        if ((tileEntity = this.getTileEntity(world = this.getWorld(ctx))) instanceof IConduitBundle) {
            return (T)((IConduitBundle)tileEntity).getConduit(this.getConType());
        }
        return null;
    }

    public static abstract class Sided<T extends IConduit>
    extends AbstractConduitPacket<T> {
        @Nonnull
        protected EnumFacing dir = EnumFacing.DOWN;

        public Sided() {
        }

        public Sided(@Nonnull T con, @Nonnull EnumFacing dir) {
            super(con);
            this.dir = dir;
        }

        @Override
        public void write(@Nonnull ByteBuf buf) {
            super.write(buf);
            buf.writeShort(this.dir.ordinal());
        }

        @Override
        public void read(@Nonnull ByteBuf buf) {
            super.read(buf);
            this.dir = EnumReader.get(EnumFacing.class, buf.readShort());
        }
    }
}

