/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.client;

import com.enderio.core.common.network.CompressedDataInput;
import crazypants.enderio.invpanel.client.ItemEntry;
import crazypants.enderio.invpanel.database.InventoryDatabase;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryDatabaseClient
extends InventoryDatabase<ItemEntry> {
    @Nonnull
    private final ArrayList<ItemEntry> clientItems;
    @Nonnull
    private final HashSet<Integer> requestedItems;
    private int itemsChangeCount;
    private int countChangeCount;

    InventoryDatabaseClient(int generation) {
        this.generation = generation;
        this.clientItems = new ArrayList();
        this.requestedItems = new HashSet();
    }

    public int getItemsChangeCount() {
        return this.itemsChangeCount;
    }

    public int getCountChangeCount() {
        return this.countChangeCount;
    }

    public void getItems(@Nonnull List<ItemEntry> outList) {
        outList.addAll(this.clientItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCompressedItems(@Nonnull byte[] compressed) throws IOException {
        try (CompressedDataInput cdi = new CompressedDataInput(compressed);){
            int numEntries = cdi.readVariable();
            for (int i = 0; i < numEntries; ++i) {
                int code = cdi.readVariable();
                int itemID = cdi.readVariable();
                int meta = cdi.readVariable();
                NBTTagCompound nbt = null;
                int dbIndex = code >> 1;
                if ((code & 1) == 1) {
                    nbt = CompressedStreamTools.func_74794_a((DataInputStream)cdi);
                }
                this.complexItems.ensureCapacity(dbIndex + 1);
                while (this.complexItems.size() <= dbIndex) {
                    this.complexItems.add(null);
                }
                ItemEntry entry = (ItemEntry)this.complexItems.get(dbIndex);
                if (entry == null) {
                    entry = (ItemEntry)this.createItemEntry(dbIndex + 65536, itemID, meta, nbt);
                    this.complexItems.set(dbIndex, entry);
                    this.complexRegistry.put(entry, entry);
                }
                int count = cdi.readVariable();
                this.setItemCount(entry, count);
            }
            ++this.itemsChangeCount;
            ++this.countChangeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<Integer> readCompressedItemList(@Nonnull byte[] compressed) throws IOException {
        try (CompressedDataInput cdi = new CompressedDataInput(compressed);){
            List<Integer> missingItems = null;
            int changed = cdi.readVariable();
            if (changed > 0) {
                for (int i = 0; i < changed; ++i) {
                    int dbID = cdi.readVariable();
                    int count = cdi.readVariable();
                    ItemEntry entry = (ItemEntry)this.getItem(dbID);
                    if (entry != null) {
                        this.setItemCount(entry, count);
                        continue;
                    }
                    missingItems = this.addMissingItems(missingItems, dbID);
                }
                ++this.countChangeCount;
            } else {
                ItemEntry entry;
                for (ItemEntry entry2 : this.clientItems) {
                    entry2.setCount(0);
                }
                this.clientItems.clear();
                this.requestedItems.clear();
                int count = cdi.readVariable();
                while (count > 0) {
                    int dbID = cdi.readUnsignedShort();
                    entry = (ItemEntry)this.getSimpleItem(dbID);
                    entry.setCount(count);
                    this.clientItems.add(entry);
                    count = cdi.readVariable();
                }
                count = cdi.readVariable();
                int dbID = 65536;
                while (count > 0) {
                    entry = (ItemEntry)this.getItem(dbID += cdi.readVariable());
                    if (entry != null) {
                        entry.setCount(count);
                        this.clientItems.add(entry);
                    } else {
                        missingItems = this.addMissingItems(missingItems, dbID);
                    }
                    count = cdi.readVariable();
                }
                ++this.itemsChangeCount;
                ++this.countChangeCount;
            }
            List<Integer> list = missingItems;
            return list;
        }
    }

    private void setItemCount(@Nonnull ItemEntry entry, int count) {
        if (entry.getCount() == 0 && count > 0) {
            this.clientItems.add(entry);
            ++this.itemsChangeCount;
        } else if (entry.getCount() > 0 && count == 0) {
            this.clientItems.remove(entry);
            ++this.itemsChangeCount;
        }
        entry.setCount(count);
    }

    @Nullable
    private List<Integer> addMissingItems(@Nullable List<Integer> list, @Nonnull Integer dbId) {
        if (!this.requestedItems.contains(dbId)) {
            if (list == null) {
                list = new ArrayList<Integer>();
            }
            list.add(dbId);
            this.requestedItems.add(dbId);
        }
        return list;
    }

    @Override
    protected ItemEntry createItemEntry(int dbId, int hash, int itemID, int meta, NBTTagCompound nbt) {
        return new ItemEntry(dbId, hash, itemID, meta, nbt);
    }
}

