/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.remote;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.invpanel.config.InvpanelConfig;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public enum ItemRemoteInvAccessType {
    BASIC(0, "_basic", 80, false, true),
    ADVANCED(1, "_advanced", -1, false, true),
    ENDER(2, "_ender", -1, true, true);

    private final String nameSuffix;
    private final int range;
    private final boolean interdimensional;
    private final boolean visible;

    private ItemRemoteInvAccessType(int index, String nameSuffix, int range, boolean interdimensional, boolean visible) {
        this.nameSuffix = nameSuffix;
        this.range = range;
        this.interdimensional = interdimensional;
        this.visible = visible;
    }

    public int toMetadata() {
        return this.ordinal();
    }

    public static ItemRemoteInvAccessType fromMetadata(int meta) {
        return ItemRemoteInvAccessType.values()[meta >= 0 && meta < ItemRemoteInvAccessType.values().length ? meta : 0];
    }

    public static ItemRemoteInvAccessType fromStack(@Nonnull ItemStack stack) {
        return ItemRemoteInvAccessType.fromMetadata(!stack.func_190926_b() ? stack.func_77960_j() : 0);
    }

    public boolean inRange(int dim0, int x0, int y0, int z0, int dim1, int x1, int y1, int z1) {
        if (!this.interdimensional && dim0 != dim1) {
            return false;
        }
        if (this.range < 0) {
            return true;
        }
        return Math.abs(x0 - x1) <= this.range && Math.abs(y0 - y1) <= this.range && Math.abs(z0 - z1) <= this.range;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    @Nonnull
    public String getUnlocalizedName(String basename) {
        return basename + this.getNameSuffix();
    }

    public int getRange() {
        return this.range;
    }

    public boolean isInterdimensional() {
        return this.interdimensional;
    }

    public int getRfCapacity() {
        return (Integer)InvpanelConfig.remoteInventoryRFCapacity.get(this.ordinal()).get();
    }

    public int getFluidCapacity() {
        return (Integer)InvpanelConfig.remoteInventoryMBCapacity.get(this.ordinal()).get();
    }

    @Nonnull
    public Fluid getFluidType() {
        Fluid fluid = null;
        String fluidname = (String)InvpanelConfig.remoteInventoryFluidTypes.get(this.ordinal()).get();
        fluid = FluidRegistry.getFluid((String)fluidname);
        if (fluid == null) {
            Log.warn("ItemRemoteInvAccessType: Could not find fluid '" + fluidname + "' using default fluid " + Fluids.NUTRIENT_DISTILLATION.getFluid());
            fluid = (Fluid)NullHelper.notnull((Object)Fluids.NUTRIENT_DISTILLATION.getFluid(), (String)"Nutrient Distillation registration went AWOL");
        }
        return fluid;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getMbPerOpen() {
        return (Integer)InvpanelConfig.remoteInventoryMBPerOpen.get(this.ordinal()).get();
    }

    public int getRfPerTick() {
        return (Integer)InvpanelConfig.remoteInventoryRFPerTick.get(this.ordinal()).get();
    }
}

