/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.killera;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.VertexRotation;
import com.enderio.core.client.render.VertexRotationFacing;
import com.enderio.core.client.render.VertexScale;
import com.enderio.core.client.render.VertexTranslation;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.fluid.ItemTankHelper;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.machine.render.MachineRenderMapper;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.ICacheKey;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.property.EnumRenderMode;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.render.util.HalfBakedQuad;
import crazypants.enderio.base.render.util.ItemQuadCollector;
import crazypants.enderio.base.render.util.QuadCollector;
import crazypants.enderio.base.render.util.TankRenderHelper;
import crazypants.enderio.machines.machine.generator.zombie.BlockZombieGenerator;
import crazypants.enderio.machines.machine.killera.BlockKillerJoe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class KillerJoeRenderMapper
extends MachineRenderMapper
implements IRenderMapper.IBlockRenderMapper.IRenderLayerAware,
IRenderMapper.IItemRenderMapper.IDynamicOverlayMapper {
    private final TextureRegistry.TextureSupplier head1;
    private final TextureRegistry.TextureSupplier head2;
    @Nonnull
    public static final KillerJoeRenderMapper killerJoe = new KillerJoeRenderMapper(BlockKillerJoe.textureHead1, BlockKillerJoe.textureHead2);
    @Nonnull
    public static final KillerJoeRenderMapper zombieGen = new KillerJoeRenderMapper(BlockZombieGenerator.textureHead1, BlockZombieGenerator.textureHead2);
    @Nonnull
    public static final KillerJoeRenderMapper enderGen = new KillerJoeRenderMapper(BlockZombieGenerator.textureHeadEnder1, BlockZombieGenerator.textureHeadEnder2);
    private static final double px = 0.0625;
    @Nonnull
    private static final Vector3d CENTER = new Vector3d(0.5, 0.5, 0.5);
    @Nonnull
    private static final double[] ROTS = new double[]{0.0, 1.5707963267948966, Math.PI, 4.71238898038469};
    @Nonnull
    private static final BoundingBox bb = new BoundingBox(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    @Nonnull
    private static final VertexTransform sca = new VertexScale(0.9, 0.9, 0.9, CENTER);
    @Nonnull
    private static final VertexTransform rotx = new VertexRotation(0.03054326, new Vector3d(1.0, 0.0, 0.0), CENTER);
    @Nonnull
    private static final VertexTransform roty = new VertexRotation(0.1745329, new Vector3d(0.0, 1.0, 0.0), CENTER);
    @Nonnull
    private static final VertexTransform rotz = new VertexRotation(0.2392846, new Vector3d(0.0, 0.0, 1.0), CENTER);
    @Nonnull
    private static final VertexTransform mov = new VertexTranslation(0.015625, -0.0625, 0.0);

    protected KillerJoeRenderMapper(TextureRegistry.TextureSupplier head1, TextureRegistry.TextureSupplier head2) {
        super(null);
        this.head1 = head1;
        this.head2 = head2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, BlockRenderLayer blockLayer, @Nonnull QuadCollector quadCollector) {
        if (blockLayer == BlockRenderLayer.TRANSLUCENT) {
            return Collections.singletonList(state.func_177230_c().func_176223_P().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT_ON)));
        }
        if (blockLayer == BlockRenderLayer.SOLID) {
            quadCollector.addQuads(null, BlockRenderLayer.SOLID, this.renderHead(state));
            return Collections.singletonList(state.func_177230_c().func_176223_P().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT)));
        }
        return null;
    }

    private List<BakedQuad> renderHead(@Nullable IBlockStateWrapper state) {
        TileEntity tileEntity;
        EnumFacing facing = EnumFacing.NORTH;
        if (state != null && (tileEntity = state.getTileEntity()) instanceof AbstractMachineEntity && (facing = ((AbstractMachineEntity)tileEntity).getFacing()).func_176740_k() == EnumFacing.Axis.X) {
            facing = facing.func_176734_d();
        }
        VertexRotationFacing rot = new VertexRotationFacing(EnumFacing.NORTH);
        rot.setCenter(CENTER);
        rot.setRotation(facing);
        TextureAtlasSprite tex1 = this.head1.get(TextureAtlasSprite.class);
        TextureAtlasSprite tex2 = this.head2.get(TextureAtlasSprite.class);
        HalfBakedQuad.HalfBakedList buffer = new HalfBakedQuad.HalfBakedList();
        buffer.add(bb, EnumFacing.NORTH, 0.0f, 0.5f, 0.0f, 0.5f, tex1, (Vector4f)null);
        buffer.add(bb, EnumFacing.EAST, 0.5f, 1.0f, 0.0f, 0.5f, tex1, (Vector4f)null);
        buffer.add(bb, EnumFacing.SOUTH, 0.0f, 0.5f, 0.5f, 1.0f, tex1, (Vector4f)null);
        buffer.add(bb, EnumFacing.WEST, 0.5f, 1.0f, 0.5f, 1.0f, tex1, (Vector4f)null);
        buffer.add(bb, EnumFacing.UP, 0.0f, 0.5f, 0.0f, 0.5f, tex2, (Vector4f)null);
        buffer.add(bb, EnumFacing.DOWN, 0.5f, 1.0f, 0.0f, 0.5f, tex2, (Vector4f)null);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        buffer.bake(quads, new VertexTransform[]{sca, rotx, roty, rotz, mov, rot});
        for (double angle : ROTS) {
            buffer = new HalfBakedQuad.HalfBakedList();
            BoundingBox bb1 = new BoundingBox(0.28125, 0.65625, 0.1875, 0.34375, 0.71875, 0.25);
            BoundingBox bb2 = new BoundingBox(0.46875, 0.59375, 0.1875, 0.53125, 0.65625, 0.25);
            BoundingBox bb3 = new BoundingBox(0.65625, 0.65625, 0.1875, 0.71875, 0.71875, 0.25);
            for (EnumFacing face : EnumFacing.values()) {
                buffer.add(bb1, face, (double)(face.ordinal() + 1) * 0.0625, (double)(face.ordinal() + 2) * 0.0625, 0.5625, 0.625, tex2, null);
                buffer.add(bb2, face, (double)(face.ordinal() + 1) * 0.0625, (double)(face.ordinal() + 2) * 0.0625, 0.625, 0.6875, tex2, null);
                buffer.add(bb3, face, (double)(face.ordinal() + 1) * 0.0625, (double)(face.ordinal() + 2) * 0.0625, 0.6875, 0.75, tex2, null);
            }
            VertexRotation rota = new VertexRotation(angle, new Vector3d(0.0, 1.0, 0.0), CENTER);
            buffer.bake(quads, new VertexTransform[]{sca, rota, rotx, roty, rotz, mov, rot});
        }
        return quads;
    }

    private List<BakedQuad> renderFuel(ItemStack stack) {
        SmartTank tank;
        HalfBakedQuad.HalfBakedList buffer;
        if (stack.func_77942_o() && (buffer = TankRenderHelper.mkTank(tank = ItemTankHelper.getTank(stack), 2.51, 1.0, 14.0, false)) != null) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            buffer.bake(quads);
            return quads;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<Pair<IBlockState, ItemStack>> mapItemRender(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ItemQuadCollector itemQuadCollector) {
        ArrayList<Pair<IBlockState, ItemStack>> states = new ArrayList<Pair<IBlockState, ItemStack>>();
        states.add(Pair.of((Object)block.func_176203_a(stack.func_77960_j()).func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT)), (Object)stack));
        if (!stack.func_77942_o()) {
            states.add((Pair<IBlockState, ItemStack>)Pair.of((Object)block.func_176203_a(stack.func_77960_j()).func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT_ON)), (Object)stack));
        }
        itemQuadCollector.addQuads(null, this.renderHead(null));
        return states;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey.addCacheKey(stack.func_77942_o());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemQuadCollector mapItemDynamicOverlayRender(@Nonnull Block block, @Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            ItemQuadCollector result = new ItemQuadCollector();
            result.addQuads(null, this.renderFuel(stack));
            result.addBlockState(block.func_176203_a(stack.func_77960_j()).func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT_ON)), stack);
            return result;
        }
        return null;
    }
}

