/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.common.block.BlockCompactPorkchop;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ObfHelper {
    private static final String OBF_VERSION = "1.12.2";
    private static boolean isObfuscated;
    public static final String[] gameProfile;
    public static final String[] mainModel;
    public static final String[] resourceDomain;
    public static final String[] resourcePath;
    public static final String getHurtSoundObf = "func_184601_bQ";
    public static final String getHurtSoundDeobf = "getHurtSound";
    public static final String getDeathSoundObf = "func_188593_c";
    public static final String getDeathSoundDeobf = "getDeathSound";
    public static final String setSizeObf = "func_70105_a";
    public static final String setSizeDeobf = "setSize";
    public static final String preRenderCallbackObf = "func_77041_b";
    public static final String preRenderCallbackDeobf = "preRenderCallback";
    public static final String getEntityTextureObf = "func_110775_a";
    public static final String getEntityTextureDeobf = "getEntityTexture";

    public static void obfWarning() {
        iChunUtil.LOGGER.warn("Error with some obfuscation!");
    }

    public static void detectObfuscation() {
        isObfuscated = true;
        try {
            Field[] fields;
            for (Field f : fields = Class.forName("net.minecraft.item.ItemBlock").getDeclaredFields()) {
                f.setAccessible(true);
                if (!f.getName().equalsIgnoreCase("block")) continue;
                isObfuscated = false;
                if (!OBF_VERSION.equals(OBF_VERSION)) {
                    iChunUtil.LOGGER.warn("ObfHelper strings are not updated!");
                    throw new RuntimeException("Bad iChun! Update obfuscation strings!");
                }
                return;
            }
            BlockCompactPorkchop.class.getDeclaredMethod("func_149722_s", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("You're running the deobf version of iChunUtil in an obfuscated environment! Don't do this!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean obfuscated() {
        return isObfuscated;
    }

    @SideOnly(value=Side.CLIENT)
    public static <T extends RenderLivingBase<V>, V extends EntityLivingBase> void invokePreRenderCallback(T rend, Class clz, V ent, float rendTick) {
        try {
            Method m = clz.getDeclaredMethod(isObfuscated ? preRenderCallbackObf : preRenderCallbackDeobf, EntityLivingBase.class, Float.TYPE);
            m.setAccessible(true);
            m.invoke(rend, ent, Float.valueOf(rendTick));
        }
        catch (NoSuchMethodException e) {
            if (clz != RenderLivingBase.class) {
                ObfHelper.invokePreRenderCallback(rend, clz.getSuperclass(), ent, rendTick);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public static <T extends Render<V>, V extends Entity> ResourceLocation getEntityTexture(T rend, Class clz, V ent) {
        try {
            Method m = clz.getDeclaredMethod(isObfuscated ? getEntityTextureObf : getEntityTextureDeobf, Entity.class);
            m.setAccessible(true);
            return (ResourceLocation)m.invoke(rend, ent);
        }
        catch (NoSuchMethodException e) {
            if (clz != Render.class) {
                return ObfHelper.getEntityTexture(rend, clz.getSuperclass(), ent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        gameProfile = new String[]{"field_146106_i", "gameProfile"};
        mainModel = new String[]{"field_77045_g", "mainModel"};
        resourceDomain = new String[]{"field_110626_a", "namespace"};
        resourcePath = new String[]{"field_110625_b", "path"};
    }
}

