/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.event;

import net.machinemuse.numina.client.render.MuseIconUtils;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.client.render.MuseTextureUtils;
import net.machinemuse.numina.item.MuseItemUtils;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.numina.math.geometry.DrawableMuseRect;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.client.model.helper.ModelHelper;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.control.KeybindManager;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableKeybinding;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RenderEventHandler {
    private static final MPSConfig config = MPSConfig.INSTANCE;
    private static boolean ownFly;
    private final DrawableMuseRect frame = new DrawableMuseRect(config.keybindHUDx(), config.keybindHUDy(), config.keybindHUDx() + 16.0, config.keybindHUDy() + 16.0, true, Colour.DARKGREEN.withAlpha(0.2), Colour.GREEN.withAlpha(0.2));

    public RenderEventHandler() {
        ownFly = false;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void preTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().equals(Minecraft.func_71410_x().func_147117_R())) {
            MuseIcon.registerIcons(event.getMap());
            ModelHelper.loadArmorModels(event.getMap());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution screen = new ScaledResolution(mc);
    }

    @SubscribeEvent
    public void onPreRenderPlayer(RenderPlayerEvent.Pre event) {
        if (!event.getEntityPlayer().field_71075_bZ.field_75100_b && !event.getEntityPlayer().field_70122_E && this.playerHasFlightOn(event.getEntityPlayer())) {
            event.getEntityPlayer().field_71075_bZ.field_75100_b = true;
            ownFly = true;
        }
    }

    private boolean playerHasFlightOn(EntityPlayer player) {
        return ModuleManager.INSTANCE.itemHasActiveModule(player.func_184582_a(EntityEquipmentSlot.CHEST), "jetpack") || ModuleManager.INSTANCE.itemHasActiveModule(player.func_184582_a(EntityEquipmentSlot.CHEST), "glider") || ModuleManager.INSTANCE.itemHasActiveModule(player.func_184582_a(EntityEquipmentSlot.FEET), "jetBoots") || ModuleManager.INSTANCE.itemHasActiveModule(player.func_184582_a(EntityEquipmentSlot.HEAD), "flightControl");
    }

    @SubscribeEvent
    public void onPostRenderPlayer(RenderPlayerEvent.Post event) {
        if (ownFly) {
            ownFly = false;
            event.getEntityPlayer().field_71075_bZ.field_75100_b = false;
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent e) {
        ItemStack helmet = e.getEntity().func_184582_a(EntityEquipmentSlot.HEAD);
        if (ModuleManager.INSTANCE.itemHasActiveModule(helmet, "binoculars")) {
            e.setNewfov(e.getNewfov() / (float)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(helmet, "fieldOfView"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPostRenderGameOverlayEvent(RenderGameOverlayEvent.Post e) {
        RenderGameOverlayEvent.ElementType elementType = e.getType();
        if (RenderGameOverlayEvent.ElementType.HOTBAR.equals((Object)elementType)) {
            this.drawKeybindToggles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawKeybindToggles() {
        if (config.keybindHUDon()) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            ScaledResolution screen = new ScaledResolution(mc);
            this.frame.setLeft(config.keybindHUDx());
            this.frame.setTop(config.keybindHUDy());
            this.frame.setBottom(this.frame.top() + 16.0);
            for (ClickableKeybinding kb : KeybindManager.getKeybindings()) {
                if (!kb.displayOnHUD) continue;
                double stringwidth = MuseRenderer.getStringWidth((String)kb.getLabel());
                this.frame.setWidth(stringwidth + (double)(kb.getBoundModules().size() * 16));
                this.frame.draw();
                MuseRenderer.drawString((String)kb.getLabel(), (double)(this.frame.left() + 1.0), (double)(this.frame.top() + 3.0), (Colour)(kb.toggleval ? Colour.RED : Colour.GREEN));
                double x = this.frame.left() + stringwidth;
                for (ClickableModule module : kb.getBoundModules()) {
                    MuseTextureUtils.pushTexture((String)"textures/atlas/blocks.png");
                    boolean active = false;
                    for (ItemStack stack : MuseItemUtils.getModularItemsEquipped((EntityPlayer)player)) {
                        if (!ModuleManager.INSTANCE.itemHasActiveModule(stack, module.getModule().getDataName())) continue;
                        active = true;
                    }
                    MuseIconUtils.drawIconAt((double)x, (double)this.frame.top(), (TextureAtlasSprite)module.getModule().getIcon(null), (Colour)(active ? Colour.WHITE : Colour.DARKGREY.withAlpha(0.5)));
                    MuseTextureUtils.popTexture();
                    x += 16.0;
                }
                this.frame.setTop(this.frame.top() + 16.0);
                this.frame.setBottom(this.frame.top() + 16.0);
            }
        }
    }
}

