/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.energy_generation;

import net.machinemuse.numina.energy.ElectricItemUtils;
import net.machinemuse.numina.item.MuseItemUtils;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.module.IToggleableModule;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.event.MovementManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class KineticGeneratorModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public KineticGeneratorModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.servoMotor, (int)2));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)1));
        this.addBasePropertyDouble("energyPerBlock", 2000.0);
        this.addTradeoffPropertyDouble("energyGenerated", "energyPerBlock", 6000.0, "RF");
        this.addBasePropertyDouble("movementResistance", 0.01);
        this.addTradeoffPropertyDouble("energyGenerated", "movementResistance", 0.49, "%");
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_ENERGY_GENERATION;
    }

    public String getDataName() {
        return "kineticGenerator";
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack itemStack) {
        if (player.field_71075_bZ.field_75100_b || player.func_184218_aH() || player.func_184613_cA() || !player.field_70122_E) {
            this.onPlayerTickInactive(player, itemStack);
        }
        if (ElectricItemUtils.getPlayerEnergy((EntityPlayer)player) < ElectricItemUtils.getMaxPlayerEnergy((EntityPlayer)player)) {
            if (!ModuleManager.INSTANCE.itemHasActiveModule(itemStack, "sprintAssist")) {
                MovementManager.setMovementModifier(itemStack, 0.0, player);
            }
            if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 20L == 0L && player.field_70122_E) {
                double distance = player.field_70140_Q - player.field_70141_P;
                ElectricItemUtils.givePlayerEnergy((EntityPlayer)player, (int)((int)(distance * 10.0 * ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "energyPerBlock"))));
            }
        }
    }

    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        if (!ModuleManager.INSTANCE.itemHasModule(item, "sprintAssist")) {
            MovementManager.setMovementModifier(item, 0.0, player);
        }
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.kineticGenerator;
    }
}

