/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.orechidendium.init.integration;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import p455w0rd.orechidendium.api.OrechidEndiumAPI;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.botania.OrechidEndium")
@ModOnly(value="orechidendium")
@ZenRegister
public class CraftTweaker {
    private static final List<IAction> LATE_REMOVALS = new LinkedList<IAction>();
    private static final List<IAction> LATE_ADDITIONS = new LinkedList<IAction>();

    public static void performCraftTweakerActions() {
        try {
            LATE_REMOVALS.forEach(CraftTweakerAPI::apply);
            LATE_ADDITIONS.forEach(CraftTweakerAPI::apply);
        }
        catch (Exception e) {
            e.printStackTrace();
            CraftTweakerAPI.logError((String)"Error while applying actions", (Throwable)e);
        }
    }

    public static void registerCommand() {
        CTChatCommand.registerCommand((CraftTweakerCommand)new OrechidEndiumLogger());
    }

    @ZenMethod
    public static void setOre(IOreDictEntry oreDict, int weight) {
        LATE_ADDITIONS.add(new Set(oreDict.getName(), weight));
    }

    @ZenMethod
    public static void setOre(String oreDict, int weight) {
        LATE_ADDITIONS.add(new Set(oreDict, weight));
    }

    @ZenMethod
    public static void addOre(IOreDictEntry oreDict, int weight) {
        CraftTweaker.setOre(oreDict, weight);
    }

    @ZenMethod
    public static void addOre(String oreDict, int weight) {
        CraftTweaker.setOre(oreDict, weight);
    }

    @ZenMethod
    public static void removeOre(IOreDictEntry oreDict) {
        LATE_REMOVALS.add(new Remove(oreDict.getName()));
    }

    @ZenMethod
    public static void removeOre(String oreDict) {
        LATE_REMOVALS.add(new Remove(oreDict));
    }

    @ZenMethod
    public static void clear() {
        CraftTweaker.removeOre("*");
    }

    public static class OrechidEndiumLogger
    extends CraftTweakerCommand {
        public OrechidEndiumLogger() {
            super("botorechidendium");
        }

        public void executeCommand(MinecraftServer server, ICommandSender sender, String[] arguments) {
            for (String str : OrechidEndiumAPI.getOreWeights().keySet()) {
                CraftTweakerAPI.logCommand((String)(str + ": " + OrechidEndiumAPI.getOreWeightEnd(str)));
            }
            if (sender != null) {
                sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog((String)(TextFormatting.DARK_PURPLE + "" + TextFormatting.ITALIC + "Orechid Endium List generated"), (ICommandSender)sender));
            }
        }

        protected void init() {
        }
    }

    private static class Remove
    implements IAction {
        String oreDict;

        public Remove(String ore) {
            this.oreDict = ore;
        }

        public void apply() {
            if (this.oreDict.equals("*")) {
                OrechidEndiumAPI.clear();
                return;
            }
            OrechidEndiumAPI.removeOre(this.oreDict);
        }

        public String describe() {
            if (this.oreDict.equals("*")) {
                return "Cleared Orchid Endium Ore Weights List";
            }
            return "Removing Orechid Endium Ore: " + this.oreDict;
        }
    }

    private static class Set
    implements IAction {
        String oreDict;
        int weight;

        public Set(String ore, int prop) {
            this.oreDict = ore;
            this.weight = prop;
        }

        public void apply() {
            OrechidEndiumAPI.addOreWeightEnd(this.oreDict, this.weight, true);
        }

        public String describe() {
            return "Adding Orechid Endium Ore Weight: " + this.oreDict + ":" + this.weight;
        }
    }
}

