/*
 * Decompiled with CFR 0.152.
 */
package com.ToMe.ToMeTinkers;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;

public class Config
extends Configuration {
    public static final String CATEGORY_MATERIALS = "materials";
    public static final String CATEGORY_MODIFIERS = "modifiers";
    public static Map<String, Boolean> materials = new HashMap<String, Boolean>();
    public static Map<String, Boolean> modifiers = new HashMap<String, Boolean>();
    public static boolean meltGems = false;
    public static boolean debug = false;
    public static boolean cosmicBedrockMiner = true;
    public static boolean supermassiveResistant = true;
    public static boolean neutroniumNuggetOreDict = true;
    public static boolean gemDilithiumOreDict = true;
    public static boolean enchGoldenAppleRecipe = true;
    public static boolean avaritiaArrowShafts = false;
    public static boolean cosmicFullArmorFlight = true;
    public static boolean shaftCastRecipe = true;
    public static boolean boundTweak = true;

    public Config(File cfg) {
        super(cfg);
        try {
            this.load();
            this.readConfig();
        }
        finally {
            if (this.hasChanged()) {
                this.save();
            }
        }
    }

    public void readConfig() {
        this.addCustomCategoryComment("general", "The General Configuration for this Mod.");
        this.addCustomCategoryComment(CATEGORY_MATERIALS, "The Materials Configuration for this Mod.(used to Enable / Disable Materials)");
        this.addCustomCategoryComment(CATEGORY_MODIFIERS, "The Modifiers Configuration for this Mod.(used to Enable / Disable Modifiers)");
        meltGems = this.getBoolean("meltGems", "general", meltGems, "Whether gems should be used in the Smeltery / Casting Table. (if false gems will be used in the Part Builder)");
        debug = this.getBoolean("debug", "general", debug, "Enables / Disables some debug output.");
        cosmicBedrockMiner = this.getBoolean("cosmicBedrockMiner", "general", cosmicBedrockMiner, "Should tools with the Cosmic Trait be able to mine Bedrock?");
        supermassiveResistant = this.getBoolean("supermassiveResistant", "general", supermassiveResistant, "Should supermassive(Neutronium Trait) work as Resistant 3?");
        neutroniumNuggetOreDict = this.getBoolean("neutroniumNuggetOreDict", "general", neutroniumNuggetOreDict, "Registers Avaritias Neutronium Nugget as OreDictionary \"nuggetCosmicNeutronium\".");
        gemDilithiumOreDict = this.getBoolean("gemDilithiumOreDict", "general", gemDilithiumOreDict, "Registers Advanced Rocketrys Dilithium Crystal as OreDictionary \"gemDilithium\".");
        enchGoldenAppleRecipe = this.getBoolean("enchantedGoldenAppleRecipe", "general", enchGoldenAppleRecipe, "Should ToMeTinkers re-add the old Enchanted Golden Apple Recipe?");
        avaritiaArrowShafts = this.getBoolean("avaritiaArrowShafts", "general", avaritiaArrowShafts, "Should Players be able to make Arrowshafts out of Avaritia Materials?");
        cosmicFullArmorFlight = this.getBoolean("cosmicFullArmorFlight", "general", cosmicFullArmorFlight, "Should Players with a full Armor with Infinity parts be able to fly?");
        shaftCastRecipe = this.getBoolean("shaftCastRecipe", "general", shaftCastRecipe, "Should Players be able to craft Arrowshaft Casts?(they can't be casted because that creates gold bolt cores, and i cant change that.)");
        boundTweak = this.getBoolean("boundTweak", "general", boundTweak, "Tweak the EntityPlayer class to make the bound modifier more reliable");
    }

    public boolean getMaterialEnable(String mat) {
        if (!materials.containsKey(mat)) {
            this.load();
            materials.put(mat, true);
            materials.put(mat, this.getBoolean(mat, CATEGORY_MATERIALS, materials.get(mat), "Enables / Disables the Material " + mat + "."));
            if (this.hasChanged()) {
                this.save();
            }
        }
        return materials.get(mat);
    }

    public boolean getModifierEnable(String mod) {
        if (!modifiers.containsKey(mod)) {
            this.load();
            modifiers.put(mod, true);
            modifiers.put(mod, this.getBoolean(mod, CATEGORY_MODIFIERS, modifiers.get(mod), "Enables / Disables the Material " + mod + "."));
            if (this.hasChanged()) {
                this.save();
            }
        }
        return modifiers.get(mod);
    }
}

