/*
 * Decompiled with CFR 0.152.
 */
package com.ToMe.ToMeTinkers;

import com.ToMe.ToMeTinkers.ToMeTinkers;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.tools.modifiers.ModExtraTrait;

public class Util {
    public static boolean hasTrait(EntityPlayer player, AbstractTrait trait) {
        for (ItemStack stack : player.func_184209_aF()) {
            if (!TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)stack), (String)trait.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public static Material getHeadMaterial(NBTTagCompound rootTag) {
        NBTTagList tagList = TagUtil.getBaseMaterialsTagList((NBTTagCompound)rootTag);
        List materials = TinkerUtil.getMaterialsFromTagList((NBTTagList)tagList);
        return materials.size() > 1 ? (Material)materials.get(1) : (Material)materials.get(0);
    }

    public static NonNullList<IModifier> getModifiers(NBTTagCompound rootCompound) {
        NonNullList result = NonNullList.func_191196_a();
        NBTTagList modifierList = TagUtil.getModifiersTagList((NBTTagCompound)rootCompound);
        for (int i = 0; i < modifierList.func_74745_c(); ++i) {
            NBTTagCompound tag = modifierList.func_150305_b(i);
            ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)tag);
            IModifier modifier = TinkerRegistry.getModifier((String)data.identifier);
            if (modifier == null) continue;
            result.add((Object)modifier);
        }
        return result;
    }

    public static boolean hasEmbossment(NBTTagCompound rootCompound, ITrait trait, boolean debug) {
        for (IModifier mod : Util.getModifiers(rootCompound)) {
            if (!(mod instanceof ModExtraTrait)) continue;
            ModExtraTrait embossment = (ModExtraTrait)mod;
            try {
                Field traits = ModExtraTrait.class.getDeclaredField("traits");
                traits.setAccessible(true);
                Collection traitList = (Collection)traits.get(embossment);
                if (debug) {
                    String traitsStr = "";
                    for (ITrait tr : traitList) {
                        traitsStr = traitsStr + tr.getIdentifier() + ", ";
                    }
                    traitsStr = traitsStr.substring(0, traitsStr.length() - 2);
                    ToMeTinkers.logger.info("Util: found Traits: " + traitsStr);
                }
                if (!traitList.contains(trait)) continue;
                if (debug) {
                    ToMeTinkers.logger.info("Util: found that Trait!");
                }
                return true;
            }
            catch (Exception e) {
                ToMeTinkers.logger.catching((Throwable)e);
            }
        }
        if (debug) {
            ToMeTinkers.logger.info("Util: cant find Trait " + trait.getIdentifier());
            ToMeTinkers.logger.info("modifiers NBT: " + TagUtil.getModifiersTagList((NBTTagCompound)rootCompound).toString());
        }
        return false;
    }

    public static int getTraitItems(EntityPlayer player, AbstractTrait trait) {
        int count = 0;
        for (ItemStack stack : player.func_184209_aF()) {
            if (!TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)stack), (String)trait.getIdentifier())) continue;
            ++count;
        }
        return count;
    }
}

