/*
 * Decompiled with CFR 0.152.
 */
package com.ToMe.ToMeTinkers.traits;

import com.ToMe.ToMeTinkers.Config;
import com.ToMe.ToMeTinkers.ToMeTinkers;
import com.ToMe.ToMeTinkers.Util;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitCosmic
extends AbstractTrait {
    private static Random rand = new Random();

    public TraitCosmic() {
        super("avaritia_cosmic", 0xFFFFFF);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void updateNBTforTrait(NBTTagCompound modifierTag, int newColor) {
        super.updateNBTforTrait(modifierTag, newColor);
        ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)modifierTag);
        data.level = 0;
        data.write(modifierTag);
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)modifierTag);
        NBTTagCompound toolTag = TagUtil.getToolTag((NBTTagCompound)rootCompound);
        int modifiers = toolTag.func_74762_e("FreeModifiers") + 5;
        ++data.level;
        NBTTagList parts = TagUtil.getBaseMaterialsTagList((NBTTagCompound)rootCompound);
        if (data.level == 1 && parts.func_74745_c() < 3) {
            try {
                if (Util.getHeadMaterial(rootCompound).getAllTraits().contains((Object)this)) {
                    ++data.level;
                    modifiers += 5;
                }
            }
            catch (Exception e) {
                ToMeTinkers.logger.catching((Throwable)e);
            }
        }
        data.write(modifierTag);
        toolTag.func_74768_a("FreeModifiers", Math.max(0, modifiers));
        TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)toolTag);
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        if (event.getHarvester().func_184614_ca() == null && event.getHarvester().func_184592_cb() == null) {
            return;
        }
        for (ItemStack stack : event.getHarvester().func_184209_aF()) {
            if (stack == null || !stack.func_77942_o() || !(stack.func_77973_b() instanceof ToolCore) || !Util.getHeadMaterial(TagUtil.getTagSafe((ItemStack)stack)).getAllTraits().contains((Object)this)) continue;
            int lvl = this.getCosmicLevel(TagUtil.getTagSafe((ItemStack)stack));
            int luck = Math.min(3, lvl);
            NBTTagList tagList = TagUtil.getBaseMaterialsTagList((NBTTagCompound)TagUtil.getTagSafe((ItemStack)stack));
            if (lvl == tagList.func_74745_c()) {
                ++luck;
            }
            try {
                Class<?> EventHandler2 = Class.forName("morph.avaritia.handler.AvaritiaEventHandler");
                Method applyLuck = EventHandler2.getDeclaredMethod("applyLuck", BlockEvent.HarvestDropsEvent.class, Integer.TYPE);
                applyLuck.invoke(null, event, luck);
            }
            catch (Exception e) {
                ToMeTinkers.logger.catching((Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerMine(PlayerInteractEvent event) {
        if (!Config.cosmicBedrockMiner || event.getWorld().field_72995_K || event.getEntityPlayer().func_184614_ca().func_190926_b() && event.getEntityPlayer().func_184592_cb().func_190926_b() || event.getEntityPlayer().field_71075_bZ.field_75098_d) {
            return;
        }
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        ItemStack held = event.getEntityPlayer().func_184614_ca();
        if (state.func_185887_b(event.getEntityPlayer().field_70170_p, event.getPos()) <= -1.0f && held.func_77942_o() && held.func_77973_b() instanceof ToolCore && (state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151573_f)) {
            ToolCore tool = (ToolCore)held.func_77973_b();
            BlockPos pos = event.getPos();
            if (Util.getHeadMaterial(TagUtil.getTagSafe((ItemStack)held)).getAllTraits().contains((Object)this) && tool.canHarvestBlock(Blocks.field_150348_b.func_176223_P(), held)) {
                if (block.func_149745_a(rand) == 0) {
                    ItemStack drop = block.getPickBlock(state, TraitCosmic.raytraceFromEntity(event.getWorld(), (Entity)event.getEntityPlayer(), true, 10.0), event.getWorld(), event.getPos(), event.getEntityPlayer());
                    if (drop == null) {
                        drop = new ItemStack(block, 1, meta);
                    }
                    float f = 0.7f;
                    double d0 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(event.getWorld(), (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, drop);
                    entityitem.func_174867_a(10);
                    event.getWorld().func_72838_d((Entity)entityitem);
                } else {
                    block.func_180657_a(event.getWorld(), event.getEntityPlayer(), event.getPos(), state, null, event.getEntityPlayer().func_184607_cu());
                }
                event.getEntityPlayer().field_70170_p.func_175698_g(event.getPos());
                event.getWorld().func_184148_a((EntityPlayer)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187835_fT, SoundCategory.NEUTRAL, 1.0f, 0.8f);
            }
        }
    }

    private int getCosmicLevel(NBTTagCompound rootTag) {
        int lvl = 0;
        NBTTagList parts = TagUtil.getBaseMaterialsTagList((NBTTagCompound)rootTag);
        for (slimeknights.tconstruct.library.materials.Material mat : TinkerUtil.getMaterialsFromTagList((NBTTagList)parts)) {
            if (!mat.getAllTraits().contains((Object)this)) continue;
            ++lvl;
        }
        if (parts.func_74745_c() < 3 && Util.getHeadMaterial(rootTag).getAllTraits().contains((Object)this)) {
            ++lvl;
        }
        if (Util.hasEmbossment(rootTag, (ITrait)this, false)) {
            ++lvl;
        }
        return lvl;
    }

    public static RayTraceResult raytraceFromEntity(World world, Entity player, boolean wut, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        Vec3d vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_72901_a(vec3, vec31, wut);
    }
}

