/*
 * Decompiled with CFR 0.152.
 */
package com.ToMe.ToMeTinkers.traits;

import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.traits.AbstractArmorTrait;
import com.ToMe.ToMeTinkers.Config;
import com.ToMe.ToMeTinkers.ToMeTinkers;
import com.ToMe.ToMeTinkers.Util;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitCosmicArmor
extends AbstractArmorTrait {
    private static List<String> fullInfinityPlayers = new ArrayList<String>();
    private static List<String> playersWithHat = new ArrayList<String>();
    private static List<String> playersWithChest = new ArrayList<String>();
    private static List<String> playersWithLeg = new ArrayList<String>();
    private static List<String> playersWithFoot = new ArrayList<String>();
    private static int errorMessageDelay = 0;
    private static boolean deobf = false;

    public TraitCosmicArmor() {
        super("avaritia_cosmic", 0xFFFFFF);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void updateNBTforTrait(NBTTagCompound modifierTag, int newColor) {
        super.updateNBTforTrait(modifierTag, newColor);
        ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)modifierTag);
        data.level = 0;
        data.write(modifierTag);
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)modifierTag);
        NBTTagCompound toolTag = TagUtil.getToolTag((NBTTagCompound)rootCompound);
        int modifiers = toolTag.func_74762_e("FreeModifiers") + 5;
        ++data.level;
        NBTTagList parts = TagUtil.getBaseMaterialsTagList((NBTTagCompound)rootCompound);
        if (data.level == 1 && parts.func_74745_c() < 3) {
            try {
                if (Util.getHeadMaterial(rootCompound).getAllTraits().contains((Object)this)) {
                    ++data.level;
                    modifiers += 5;
                }
            }
            catch (Exception e) {
                ToMeTinkers.logger.catching((Throwable)e);
            }
        }
        data.write(modifierTag);
        toolTag.func_74768_a("FreeModifiers", Math.max(0, modifiers));
        TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)toolTag);
    }

    private int getCosmicLevel(NBTTagCompound rootTag) {
        int lvl = 0;
        NBTTagList parts = TagUtil.getBaseMaterialsTagList((NBTTagCompound)rootTag);
        for (slimeknights.tconstruct.library.materials.Material mat : TinkerUtil.getMaterialsFromTagList((NBTTagList)parts)) {
            if (!mat.getAllTraits().contains((Object)this)) continue;
            ++lvl;
        }
        if (parts.func_74745_c() < 3 && Util.getHeadMaterial(rootTag).getAllTraits().contains((Object)this)) {
            ++lvl;
        }
        if (Util.hasEmbossment(rootTag, (ITrait)this, false)) {
            ++lvl;
        }
        return lvl;
    }

    public float onHurt(ItemStack armor, EntityPlayer player, DamageSource source, float damage, float newDamage, LivingHurtEvent evt) {
        if (playersWithChest.contains(TraitCosmicArmor.playerKey(player)) && source.func_76347_k()) {
            if (evt.isCancelable()) {
                evt.setCanceled(true);
            }
            newDamage = 0.0f;
            damage = 0.0f;
            if (player.func_70027_ad()) {
                player.func_70066_B();
            }
            return 0.0f;
        }
        return super.onHurt(armor, player, source, damage, newDamage, evt);
    }

    @SubscribeEvent
    public void updatePlayerAbilityStatus(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            boolean hasHead = this.hasCosmic(player.func_184582_a(EntityEquipmentSlot.HEAD));
            boolean hasChest = this.hasCosmic(player.func_184582_a(EntityEquipmentSlot.CHEST));
            boolean hasLegs = this.hasCosmic(player.func_184582_a(EntityEquipmentSlot.LEGS));
            boolean hasFeet = this.hasCosmic(player.func_184582_a(EntityEquipmentSlot.FEET));
            boolean fullInfi = hasHead && hasChest && hasLegs && hasFeet;
            String key = TraitCosmicArmor.playerKey(player);
            if (Config.cosmicFullArmorFlight) {
                if (fullInfinityPlayers.contains(key)) {
                    if (fullInfi) {
                        player.field_71075_bZ.field_75101_c = true;
                    } else {
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.field_71075_bZ.field_75101_c = false;
                            player.field_71075_bZ.field_75100_b = false;
                        }
                        fullInfinityPlayers.remove(key);
                    }
                } else if (fullInfi) {
                    fullInfinityPlayers.add(key);
                }
            }
            if (playersWithHat.contains(key)) {
                if (hasHead) {
                    boolean error;
                    block50: {
                        player.func_70050_g(300);
                        PotionEffect nv = player.func_70660_b(MobEffects.field_76439_r);
                        if (nv == null) {
                            nv = new PotionEffect(MobEffects.field_76439_r, 300, 0, false, false);
                            player.func_70690_d(nv);
                        }
                        error = false;
                        try {
                            Field duration = null;
                            if (deobf) {
                                try {
                                    duration = PotionEffect.class.getDeclaredField("duration");
                                }
                                catch (Exception e) {
                                    if (errorMessageDelay < 1) {
                                        ToMeTinkers.logger.catching((Throwable)e);
                                    }
                                    error = true;
                                }
                            } else {
                                try {
                                    duration = PotionEffect.class.getDeclaredField("field_76460_b");
                                }
                                catch (Exception e) {
                                    try {
                                        duration = PotionEffect.class.getDeclaredField("duration");
                                        deobf = true;
                                    }
                                    catch (Exception e1) {
                                        if (errorMessageDelay < 1) {
                                            ToMeTinkers.logger.catching((Throwable)e);
                                            ToMeTinkers.logger.catching((Throwable)e1);
                                        }
                                        error = true;
                                    }
                                }
                            }
                            duration.setAccessible(true);
                            duration.set(nv, 300);
                        }
                        catch (Exception e) {
                            if (error) break block50;
                            if (errorMessageDelay < 1) {
                                ToMeTinkers.logger.catching((Throwable)e);
                            }
                            error = true;
                        }
                    }
                    if (error) {
                        if (errorMessageDelay < 1) {
                            ToMeTinkers.logger.warn("A unknown Error occured while trying to change Potion duration.");
                            ToMeTinkers.logger.warn("This doesn't means any feature fails completly but the NightVision effect is flashing most of the time.");
                            errorMessageDelay = 100;
                        } else {
                            --errorMessageDelay;
                        }
                    }
                } else {
                    playersWithHat.remove(key);
                }
            } else if (hasHead) {
                playersWithHat.add(key);
            }
            if (playersWithChest.contains(key)) {
                if (hasChest) {
                    if (player.func_70027_ad()) {
                        player.func_70066_B();
                    }
                } else {
                    playersWithChest.remove(key);
                }
            } else if (hasChest) {
                playersWithChest.add(key);
            }
            if (playersWithLeg.contains(key)) {
                if (hasLegs) {
                    boolean swimming;
                    boolean flying = player.field_71075_bZ.field_75100_b;
                    boolean bl = swimming = player.func_70055_a(Material.field_151586_h) || player.func_70090_H();
                    if (player.field_70122_E || flying || swimming) {
                        boolean sneaking = player.func_70093_af();
                        float speed = 0.15f * (flying ? 1.1f : 1.0f) * (sneaking ? 0.1f : 1.0f);
                        if (player.field_191988_bg > 0.0f) {
                            player.func_191958_b(0.0f, 0.0f, 1.0f, speed);
                        } else if (player.field_191988_bg < 0.0f) {
                            player.func_191958_b(0.0f, 0.0f, 1.0f, -speed * 0.3f);
                        }
                        if (player.field_70702_br != 0.0f) {
                            player.func_191958_b(1.0f, 0.0f, 0.0f, speed * 0.5f * Math.signum(player.field_70702_br));
                        }
                    }
                } else {
                    playersWithLeg.remove(key);
                }
            } else if (hasLegs) {
                playersWithLeg.add(key);
            }
            if (playersWithFoot.contains(key)) {
                if (!hasFeet) {
                    playersWithFoot.remove(key);
                }
            } else if (hasFeet) {
                playersWithFoot.add(key);
            }
        }
    }

    @SubscribeEvent
    public void jumpBoost(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        String key;
        if (event.getEntityLiving() instanceof EntityPlayer && playersWithFoot.contains(key = TraitCosmicArmor.playerKey(player = (EntityPlayer)event.getEntityLiving()))) {
            player.field_70181_x += (double)0.4f;
        }
    }

    public void onFalling(ItemStack armor, EntityPlayer player, LivingFallEvent evt) {
        String key = TraitCosmicArmor.playerKey(player);
        if (playersWithFoot.contains(key) && evt.isCancelable()) {
            evt.setCanceled(true);
        }
    }

    private boolean hasCosmic(ItemStack stack) {
        return stack.func_77973_b() instanceof ArmorCore && TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)stack), (String)this.identifier);
    }

    public static String playerKey(EntityPlayer player) {
        return player.func_146103_bH().getName() + ":" + player.field_70170_p.field_72995_K;
    }
}

