/*
 * Decompiled with CFR 0.152.
 */
package com.ToMe.ToMeTinkers.traits;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.traits.AbstractTraitLeveled;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitReinforced
extends AbstractTraitLeveled {
    private static final float chancePerLevel = 0.2f;
    public static final String TAG_UNBREAKABLE = "Unbreakable";
    private final int lvl;

    public TraitReinforced(int lvl) {
        super("reinforced", 0xFFFFFF, 10, lvl);
        this.lvl = lvl;
    }

    private float getReinforcedChance(NBTTagCompound modifierTag) {
        return (float)this.lvl * 0.2f;
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        if (this.getReinforcedChance(modifierTag) >= 1.0f) {
            rootCompound.func_74757_a(TAG_UNBREAKABLE, true);
        }
    }

    public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
        if (entity.func_130014_f_().field_72995_K) {
            return 0;
        }
        NBTTagCompound tag = TinkerUtil.getModifierTag((ItemStack)tool, (String)this.identifier);
        float chance = this.getReinforcedChance(tag);
        if (chance >= random.nextFloat()) {
            newDamage -= damage;
        }
        return Math.max(0, newDamage);
    }

    public String getLocalizedDesc() {
        return String.format(super.getLocalizedDesc(), Util.dfPercent.format(0.2f));
    }

    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        if (this.lvl == 10) {
            return Util.translate((String)"modifier.reinforced.unbreakable", (Object[])new Object[0]);
        }
        return super.getTooltip(modifierTag, detailed);
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getIdentifier());
        if (I18n.func_94522_b((String)loc)) {
            float chance = this.getReinforcedChance(modifierTag);
            String chanceStr = Util.dfPercent.format(chance);
            if (chance >= 1.0f) {
                chanceStr = Util.translate((String)"modifier.reinforced.unbreakable", (Object[])new Object[0]);
            }
            return ImmutableList.of((Object)Util.translateFormatted((String)loc, (Object[])new Object[]{chanceStr}));
        }
        return super.getExtraInfo(tool, modifierTag);
    }
}

