/*
 * Decompiled with CFR 0.152.
 */
package com.ToMe.ToMeTinkers.traits;

import c4.conarm.lib.traits.AbstractArmorTrait;
import com.ToMe.ToMeTinkers.Config;
import com.ToMe.ToMeTinkers.Util;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitSupermassiveArmor
extends AbstractArmorTrait {
    public TraitSupermassiveArmor() {
        super("avaritia_supermassive", 0xFFFFFF);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onKnockback(ItemStack armor, EntityPlayer player, LivingKnockBackEvent evt) {
        int level = this.getSupermassiveLevel(TagUtil.getTagSafe((ItemStack)armor));
        evt.setStrength(evt.getStrength() / (0.55f * (float)level));
        super.onKnockback(armor, player, evt);
    }

    public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
        if (Config.supermassiveResistant) {
            if (entity.func_130014_f_().field_72995_K) {
                return 0;
            }
            float chance = 0.6f;
            if (chance >= random.nextFloat()) {
                newDamage -= damage;
            }
            return Math.max(0, newDamage);
        }
        return super.onToolDamage(tool, damage, newDamage, entity);
    }

    private int getSupermassiveLevel(NBTTagCompound rootTag) {
        int lvl = 0;
        NBTTagList parts = TagUtil.getBaseMaterialsTagList((NBTTagCompound)rootTag);
        for (Material mat : TinkerUtil.getMaterialsFromTagList((NBTTagList)parts)) {
            if (!mat.getAllTraits().contains((Object)this)) continue;
            ++lvl;
        }
        if (Util.hasEmbossment(rootTag, (ITrait)this, false)) {
            ++lvl;
        }
        return lvl;
    }
}

