/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.fluid;

import com.existingeevee.moretcon.fluid.LiquidFluid;
import com.existingeevee.moretcon.other.CompatManager;
import com.existingeevee.moretcon.other.RegisterHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;

public class ModFluids {
    public static int totalFluids;
    public static Fluid liquidFusionite;
    public static Fluid liquidSyrmorite;
    public static Fluid liquidOctine;
    public static Fluid liquidIrradium;
    public static Fluid liquidSolarSteel;
    public static Fluid liquidGallium;
    public static Fluid liquidPenguinite;
    public static Fluid liquidHydrogen;
    public static Fluid liquidBurningSulfurFlow;
    public static Fluid liquidEmber;
    public static Fluid liquidIronwood;
    public static Fluid liquidArkenium;
    public static Fluid liquidRuneSteel;
    public static Fluid liquidGravitonium;
    public static Fluid liquidValkyrieMetal;
    public static Fluid liquidTrichromadentium;

    private static void registerFluids(Fluid ... fluid) {
        for (Fluid i : fluid) {
            ModFluids.addFluid(i);
        }
    }

    public static void init() {
        if (CompatManager.loadMain) {
            ModFluids.registerFluids(liquidFusionite, liquidIrradium, liquidSolarSteel, liquidHydrogen, liquidGallium, liquidRuneSteel, liquidGravitonium, liquidTrichromadentium);
        }
        if (CompatManager.twilightforest) {
            ModFluids.registerFluids(liquidPenguinite, liquidIronwood);
        }
        if (CompatManager.thebetweenlands) {
            ModFluids.registerFluids(liquidSyrmorite, liquidBurningSulfurFlow, liquidOctine, liquidEmber);
        }
        if (CompatManager.aether_legacy) {
            ModFluids.registerFluids(liquidArkenium, liquidValkyrieMetal);
        }
        if (CompatManager.jokes) {
            // empty if block
        }
    }

    private static void addFluid(Fluid fluid) {
        RegisterHelper.registerFluid(fluid);
    }

    static {
        liquidFusionite = new LiquidFluid("liquidfusionite", new ResourceLocation("moretcon:blocks/fluids/liquidfusionite_still"), new ResourceLocation("moretcon:blocks/fluids/liquidfusionite_flowing")).setCColor(0x3399FF).setLuminosity(15).setDensity(1000).setViscosity(2000).setTemperature(1000);
        liquidSyrmorite = new LiquidFluid("liquidsyrmorite", new ResourceLocation("moretcon:blocks/fluids/liquidsyrmorite_still"), new ResourceLocation("moretcon:blocks/fluids/liquidsyrmorite_flowing")).setCColor(2310535).setLuminosity(10).setDensity(1000).setViscosity(2000).setTemperature(1000);
        liquidOctine = new LiquidFluid("liquidoctine", new ResourceLocation("moretcon:blocks/fluids/liquidoctine_still"), new ResourceLocation("moretcon:blocks/fluids/liquidoctine_flowing")).setCColor(16744966).setLuminosity(15).setDensity(1000).setViscosity(2000).setTemperature(1200);
        liquidIrradium = new LiquidFluid("liquidirradium", new ResourceLocation("moretcon:blocks/fluids/liquidirradium_still"), new ResourceLocation("moretcon:blocks/fluids/liquidirradium_flowing")).setCColor(60672).setLuminosity(15).setDensity(1000).setViscosity(4000).setTemperature(1000);
        liquidSolarSteel = new LiquidFluid("liquidsolarsteel", new ResourceLocation("moretcon:blocks/fluids/liquidsolarsteel_still"), new ResourceLocation("moretcon:blocks/fluids/liquidsolarsteel_flowing")).setCColor(16756019).setLuminosity(15).setDensity(8000).setViscosity(1500).setTemperature(6000);
        liquidGallium = new LiquidFluid("liquidgallium", new ResourceLocation("moretcon:blocks/fluids/liquidgallium_still"), new ResourceLocation("moretcon:blocks/fluids/liquidgallium_flowing")).setCColor(0xFFFFFF).setLuminosity(0).setDensity(1000).setViscosity(1500).setTemperature(100);
        liquidPenguinite = new LiquidFluid("liquidpenguinite", new ResourceLocation("moretcon:blocks/fluids/liquidpenguinite_still"), new ResourceLocation("moretcon:blocks/fluids/liquidpenguinite_flowing")).setLuminosity(15).setDensity(1000).setViscosity(2000).setTemperature(250);
        liquidHydrogen = new LiquidFluid("liquidhydrogen", new ResourceLocation("moretcon:blocks/fluids/hydrogengas_still"), new ResourceLocation("moretcon:blocks/fluids/hydrogengas_flowing")).setCColor(0xFF0000).setLuminosity(0).setDensity(-5).setViscosity(1000).setTemperature(0).setGaseous(true);
        liquidBurningSulfurFlow = new LiquidFluid("burningsulfurflow", new ResourceLocation("moretcon:blocks/fluids/burningsulfurflow_still"), new ResourceLocation("moretcon:blocks/fluids/burningsulfurflow_flowing")).setCColor(16770463).setLuminosity(3).setDensity(1000).setViscosity(800).setTemperature(750);
        liquidEmber = new LiquidFluid("liquidember", new ResourceLocation("moretcon:blocks/fluids/liquidember_still"), new ResourceLocation("moretcon:blocks/fluids/liquidember_flowing")).setCColor(16744966).setLuminosity(13).setDensity(1000).setViscosity(800).setTemperature(1750);
        liquidIronwood = new LiquidFluid("liquidironwood", new ResourceLocation("moretcon:blocks/fluids/liquidironwood_still"), new ResourceLocation("moretcon:blocks/fluids/liquidironwood_flowing")).setCColor(3615239).setLuminosity(13).setDensity(1000).setViscosity(800).setTemperature(1100);
        liquidArkenium = new LiquidFluid("liquidarkenium").setCColor(0x595959).setLuminosity(13).setDensity(1000).setViscosity(800).setTemperature(1100);
        liquidRuneSteel = new LiquidFluid("liquidrunesteel").setCColor(0xCC9900).setLuminosity(13).setDensity(1000).setViscosity(800).setTemperature(1100);
        liquidGravitonium = new LiquidFluid("liquidGravitonium".toLowerCase()).setCColor(13056).setLuminosity(13).setDensity(1000).setViscosity(800).setTemperature(1100);
        liquidValkyrieMetal = new LiquidFluid("liquidValkyrieMetal".toLowerCase()).setCColor(0xFFFFFF).setLuminosity(13).setDensity(1000).setViscosity(800).setTemperature(1100);
        liquidTrichromadentium = new LiquidFluid("liquidTrichromadentium".toLowerCase()).setCColor(0xFFFFFF).setLuminosity(13).setDensity(1000).setViscosity(800).setTemperature(1100);
    }
}

