/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.materials;

import com.existingeevee.moretcon.fluid.ModFluids;
import com.existingeevee.moretcon.item.ModItems;
import com.existingeevee.moretcon.materials.UniqueMaterial;
import com.existingeevee.moretcon.other.CompatManager;
import com.existingeevee.moretcon.other.CompositeRegistry;
import com.existingeevee.moretcon.other.ConfigHandler;
import com.existingeevee.moretcon.other.Logging;
import com.existingeevee.moretcon.other.Misc;
import com.existingeevee.moretcon.other.RegisterHelper;
import com.existingeevee.moretcon.traits.ModTraits;
import java.lang.reflect.Field;
import java.util.Map;
import landmaster.plustic.tools.stats.BatteryCellMaterialStats;
import landmaster.plustic.tools.stats.LaserMediumMaterialStats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import org.apache.logging.log4j.Level;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.ProjectileMaterialStats;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTraits;
import twilightforest.compat.TConstruct;

public class Materials {
    public static int totalMaterials;
    public static Material materialWeedwood;
    public static Material materialIronwood;
    public static Material materialFusionite;
    public static Material materialSyrmorite;
    public static Material materialValonite;
    public static Material materialOctine;
    public static Material materialReedRope;
    public static Material materialAnglerTooth;
    public static Material materialDragonFlyWing;
    public static Material materialSpaceTimeDisruption;
    public static Material materialIrradium;
    public static Material materialSolarSteel;
    public static Material materialPenguinite;
    public static Material materialVoidSpar;
    public static Material materialGarstone;
    public static Material materialGallium;
    public static Material materialSlimyBone;
    public static Material materialEnderal;
    public static Material materialEnderexamite;
    public static Material materialFerroherb;
    public static Material materialRuneSteel;
    public static Material materialArkenium;
    public static Material materialSkyroot;
    public static Material materialHolystone;
    public static Material materialZanite;
    public static Material materialGravitite;
    public static Material materialValkyrieMetal;
    public static Material materialGravitonium;
    public static Material materialTrichromadentium;
    public static UniqueMaterial materialPlasma;
    public static UniqueMaterial materialShockwave;

    public static void registerMaterials(Material material) {
        Materials.addMaterial(material, material.getFluid(), material.getIdentifier().replaceFirst("moretcon.", "").substring(0, 1).toUpperCase() + material.getIdentifier().replaceFirst("moretcon.", "").substring(1));
    }

    public static void registerMaterials(Material material, String suffix) {
        Materials.addMaterial(material, material.getFluid(), suffix);
    }

    public static void registerMaterials(Material material, String suffix, boolean bypassCheck) {
        Materials.addMaterial(material, material.getFluid(), suffix, bypassCheck);
    }

    public static void init() {
        if (CompatManager.loadMain) {
            Materials.registerMaterials(materialPlasma);
            Materials.registerMaterials(materialFusionite);
            Materials.registerMaterials(materialSpaceTimeDisruption, "SpaceTimeDisruption");
            Materials.registerMaterials(materialVoidSpar, "VoidSpar");
            Materials.registerMaterials(materialEnderal);
            Materials.registerMaterials(materialIrradium);
            Materials.registerMaterials(materialSolarSteel, "SolarSteel");
            Materials.registerMaterials(materialGallium);
            Materials.registerMaterials(materialEnderexamite);
            Materials.registerMaterials(materialGarstone);
            Materials.registerMaterials(materialRuneSteel, "RuneSteel");
            Materials.registerMaterials(materialGravitonium);
            Materials.registerMaterials(materialTrichromadentium, "Trichromadentium");
        }
        if (CompatManager.twilightforest) {
            Materials.registerMaterials(materialIronwood);
            Materials.registerMaterials(materialPenguinite);
            Materials.registerMaterials(materialFerroherb);
        }
        if (CompatManager.aether_legacy) {
            Materials.registerMaterials(materialArkenium);
            Materials.registerMaterials(materialSkyroot);
            Materials.registerMaterials(materialHolystone);
            Materials.registerMaterials(materialZanite);
            Materials.registerMaterials(materialGravitite);
            Materials.registerMaterials(materialValkyrieMetal, "ValkyrieMetal");
        }
        if (CompatManager.thebetweenlands) {
            Materials.registerMaterials(materialShockwave);
            Materials.registerMaterials(materialSyrmorite);
            Materials.registerMaterials(materialOctine);
            Materials.registerMaterials(materialValonite);
            Materials.registerMaterials(materialReedRope, "ReedRope");
            Materials.registerMaterials(materialDragonFlyWing, "DragonFlyWing");
            Materials.registerMaterials(materialAnglerTooth, "AnglerTooth");
            Materials.registerMaterials(materialWeedwood, "WeedWood");
            Materials.registerMaterials(materialSlimyBone, "SlimyBone");
            if (Materials.removeTinkerMaterial(TinkerMaterials.bone)) {
                Materials.registerMaterials(TinkerMaterials.bone, "Bone", true);
            }
        }
        if (CompatManager.jokes) {
            // empty if block
        }
        Logging.log("Loaded a total of " + totalMaterials + " different TConstruct Materials.");
    }

    public static boolean removeTinkerMaterial(Material material) {
        return Materials.removeTinkerMaterial(material.getIdentifier());
    }

    public static boolean removeTinkerMaterial(String identifier) {
        boolean success = false;
        Field mat = null;
        try {
            mat = TinkerRegistry.class.getDeclaredField("materials");
            mat.setAccessible(true);
            Map fieldValue = (Map)mat.get(TinkerRegistry.class);
            success = fieldValue.entrySet().removeIf(m -> ((Material)m.getValue()).identifier.equals(identifier));
            if (!success) {
                Logging.log("Unable to remove material \"" + identifier + "\" as it was never registered", Level.ERROR);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            Logging.log("Unable to remove material \"" + identifier + "\" as an error was encountered", Level.ERROR);
            e1.printStackTrace();
        }
        return success;
    }

    public static Material forceSetRepItem(ItemStack repItem, Material material) {
        Field f = null;
        try {
            for (Field pF : Material.class.getDeclaredFields()) {
                if (!pF.getName().equals("representativeItem")) continue;
                f = pF;
                break;
            }
            f.setAccessible(true);
            f.set(material, repItem);
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException | SecurityException e1) {
            e1.printStackTrace();
        }
        return material;
    }

    private static void addMaterial(Material material, Fluid fluid, String suffix, boolean bypassCheck) {
        if (RegisterHelper.registerMaterial(material, fluid, suffix, bypassCheck) && !bypassCheck) {
            ++totalMaterials;
        }
    }

    private static void addMaterial(Material material, Fluid fluid, String suffix) {
        Materials.addMaterial(material, fluid, suffix, false);
    }

    static {
        materialWeedwood = new Material(Misc.createNonConflictiveName("weedwood".toLowerCase()), 0xCC9900);
        materialIronwood = new Material(Misc.createNonConflictiveName("ironwood".toLowerCase()), 0xCC9900);
        materialFusionite = new Material(Misc.createNonConflictiveName("fusionite".toLowerCase()), 0x3399FF);
        materialSyrmorite = new Material(Misc.createNonConflictiveName("syrmorite".toLowerCase()), 2310535);
        materialValonite = new Material(Misc.createNonConflictiveName("Valonite".toLowerCase()), 13283786);
        materialOctine = new Material(Misc.createNonConflictiveName("Octine".toLowerCase()), 16744966);
        materialReedRope = new Material(Misc.createNonConflictiveName("ReedRope".toLowerCase()), 740875);
        materialAnglerTooth = new Material(Misc.createNonConflictiveName("AnglerTooth".toLowerCase()), 0xCFCF99);
        materialDragonFlyWing = new Material(Misc.createNonConflictiveName("DragonFlyWing".toLowerCase()), 12506843);
        materialSpaceTimeDisruption = new Material(Misc.createNonConflictiveName("SpaceTimeDisruption".toLowerCase()), 0x400080);
        materialIrradium = new Material(Misc.createNonConflictiveName("irradium".toLowerCase()), 60672);
        materialSolarSteel = new Material(Misc.createNonConflictiveName("SolarSteel".toLowerCase()), 16756019);
        materialPenguinite = new Material(Misc.createNonConflictiveName("Penguinite".toLowerCase()), -421068801);
        materialVoidSpar = new Material(Misc.createNonConflictiveName("VoidSpar".toLowerCase()), -1283582465);
        materialGarstone = new Material(Misc.createNonConflictiveName("Garstone".toLowerCase()), 0xFF0A0A);
        materialGallium = new Material(Misc.createNonConflictiveName("Gallium".toLowerCase()), 0xFFFFFF);
        materialSlimyBone = new Material(Misc.createNonConflictiveName("SlimyBone".toLowerCase()), 15591103);
        materialEnderal = new Material(Misc.createNonConflictiveName("Enderal".toLowerCase()), -1288896384);
        materialEnderexamite = new Material(Misc.createNonConflictiveName("Enderexamite".toLowerCase()), 9321167);
        materialFerroherb = new Material(Misc.createNonConflictiveName("Ferroherb".toLowerCase()), 5004858);
        materialRuneSteel = new Material(Misc.createNonConflictiveName("RuneSteel".toLowerCase()), 11964510);
        materialArkenium = new Material(Misc.createNonConflictiveName("Arkenium".toLowerCase()), 0x595959);
        materialSkyroot = new Material(Misc.createNonConflictiveName("Skyroot".toLowerCase()), 7103294);
        materialHolystone = new Material(Misc.createNonConflictiveName("Holystone".toLowerCase()), 0xA3A3A3);
        materialZanite = new Material(Misc.createNonConflictiveName("Zanite".toLowerCase()), 0x6611DD);
        materialGravitite = new Material(Misc.createNonConflictiveName("Gravitite".toLowerCase()), 0xCC55AA);
        materialValkyrieMetal = new Material(Misc.createNonConflictiveName("ValkyrieMetal".toLowerCase()), 15396439);
        materialGravitonium = new Material(Misc.createNonConflictiveName("Gravitonium".toLowerCase()), 43520);
        materialTrichromadentium = new Material(Misc.createNonConflictiveName("trichromadentium".toLowerCase()), 0x777777);
        materialPlasma = new UniqueMaterial(Misc.createNonConflictiveName("plasma".toLowerCase()), 0xFF0000, "tconstruct:sword_blade", "tconstruct:broadsword");
        materialShockwave = new UniqueMaterial(Misc.createNonConflictiveName("shockwave".toLowerCase()), 10608088, ConfigHandler.registerBetweenTinkerTools ? "moretcon:blswordblade" : "tconstruct:sword_blade", ConfigHandler.registerBetweenTinkerTools ? "moretcon:blsword" : "tconstruct:broadsword");
        if (CompatManager.loadMain) {
            materialFusionite.addItem("oreFusionite", 1, Material.VALUE_Ore());
            materialFusionite.setFluid(ModFluids.liquidFusionite);
            materialFusionite.addCommonItems("Fusionite");
            materialFusionite.setCastable(true);
            materialFusionite.setCraftable(false);
            materialFusionite.setRepresentativeItem("ingotFusionite");
            materialFusionite.addTrait((ITrait)ModTraits.coldFire);
            materialFusionite.addTrait((ITrait)TinkerTraits.enderference);
            materialFusionite.addTrait((ITrait)TinkerTraits.alien);
            materialFusionite.addTrait((ITrait)TinkerTraits.dense);
            materialFusionite.addStats((IMaterialStats)new HeadMaterialStats(50, 5.0f, 8.0f, 6));
            materialFusionite.addStats((IMaterialStats)new HandleMaterialStats(3.0f, 20));
            materialFusionite.addStats((IMaterialStats)new ExtraMaterialStats(20));
            materialFusionite.addStats((IMaterialStats)new ArrowShaftMaterialStats(3.0f, 20));
            materialFusionite.addStats((IMaterialStats)new ProjectileMaterialStats());
            if (CompatManager.plustic) {
                materialFusionite.addStats((IMaterialStats)new LaserMediumMaterialStats(10.0f, 20.0f));
                materialFusionite.addStats((IMaterialStats)new BatteryCellMaterialStats(100000));
            }
            materialIrradium.addItem("oreIrradium", 1, Material.VALUE_Ore());
            materialIrradium.setFluid(ModFluids.liquidIrradium);
            materialIrradium.addCommonItems("Irradium");
            materialIrradium.setCastable(true);
            materialIrradium.setCraftable(false);
            materialIrradium.setRepresentativeItem("ingotIrradium");
            materialIrradium.addTrait((ITrait)ModTraits.radioactive);
            materialIrradium.addTrait((ITrait)TinkerTraits.momentum);
            materialIrradium.addStats((IMaterialStats)new HeadMaterialStats(70, 6.0f, 4.0f, 5));
            if (CompatManager.plustic) {
                materialIrradium.addStats((IMaterialStats)new LaserMediumMaterialStats(8.0f, 25.0f));
                materialIrradium.addStats((IMaterialStats)new BatteryCellMaterialStats(480000));
            }
            materialIrradium.addStats((IMaterialStats)new HandleMaterialStats(3.0f, 40));
            materialIrradium.addStats((IMaterialStats)new ExtraMaterialStats(40));
            materialIrradium.addStats((IMaterialStats)new ArrowShaftMaterialStats(3.0f, 20));
            materialIrradium.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialSolarSteel.setFluid(ModFluids.liquidSolarSteel);
            materialSolarSteel.addCommonItems("SolarSteel");
            materialSolarSteel.setCastable(true);
            materialSolarSteel.setCraftable(false);
            materialSolarSteel.setRepresentativeItem("ingotSolarSteel");
            materialSolarSteel.addTrait((ITrait)TinkerTraits.flammable);
            materialSolarSteel.addTrait((ITrait)TinkerTraits.superheat);
            materialSolarSteel.addTrait((ITrait)TinkerTraits.dense);
            materialSolarSteel.addTrait((ITrait)TinkerTraits.autosmelt);
            if (CompatManager.plustic) {
                materialSolarSteel.addStats((IMaterialStats)new LaserMediumMaterialStats(15.0f, 20.0f));
                materialSolarSteel.addStats((IMaterialStats)new BatteryCellMaterialStats(2000));
            }
            materialSolarSteel.addStats((IMaterialStats)new HeadMaterialStats(450, 18.0f, 14.0f, 7));
            materialSolarSteel.addStats((IMaterialStats)new HandleMaterialStats(4.0f, 60));
            materialSolarSteel.addStats((IMaterialStats)new ExtraMaterialStats(60));
            materialSolarSteel.addStats((IMaterialStats)new ArrowShaftMaterialStats(3.0f, 20));
            materialTrichromadentium.addItem("oreTrichromadentium", 1, Material.VALUE_Ore());
            materialTrichromadentium.addCommonItems("Trichromadentium");
            materialTrichromadentium.setFluid(ModFluids.liquidTrichromadentium);
            materialTrichromadentium.setCastable(true);
            materialTrichromadentium.setCraftable(false);
            materialTrichromadentium.setRepresentativeItem("ingotTrichromadentium");
            materialTrichromadentium.addTrait((ITrait)ModTraits.trichromic);
            if (CompatManager.plustic) {
                materialTrichromadentium.addStats((IMaterialStats)new LaserMediumMaterialStats(15.0f, 20.0f));
                materialTrichromadentium.addStats((IMaterialStats)new BatteryCellMaterialStats(2000));
            }
            materialTrichromadentium.addStats((IMaterialStats)new HeadMaterialStats(1800, 20.0f, 16.0f, 8));
            materialTrichromadentium.addStats((IMaterialStats)new HandleMaterialStats(4.0f, 60));
            materialTrichromadentium.addStats((IMaterialStats)new ExtraMaterialStats(500));
            materialTrichromadentium.addStats((IMaterialStats)new ArrowShaftMaterialStats(3.0f, 75));
            materialSpaceTimeDisruption.addItem(ModItems.spaceTimeDisruptionPowder, 1, 36);
            materialSpaceTimeDisruption.setCastable(false);
            materialSpaceTimeDisruption.setCraftable(true);
            materialSpaceTimeDisruption.setRepresentativeItem(ModItems.spaceTimeDisruptionPowder);
            materialSpaceTimeDisruption.addTrait((ITrait)TinkerTraits.lightweight);
            materialSpaceTimeDisruption.addTrait((ITrait)TinkerTraits.dense);
            if (CompatManager.plustic) {
                materialSpaceTimeDisruption.addStats((IMaterialStats)new LaserMediumMaterialStats(13.0f, 25.0f));
                materialSpaceTimeDisruption.addStats((IMaterialStats)new BatteryCellMaterialStats(520000));
            }
            materialSpaceTimeDisruption.addStats((IMaterialStats)new HeadMaterialStats(5, 10.0f, 8.0f, 6));
            materialSpaceTimeDisruption.addStats((IMaterialStats)new HandleMaterialStats(3.0f, 2));
            materialSpaceTimeDisruption.addStats((IMaterialStats)new ExtraMaterialStats(4));
            materialSpaceTimeDisruption.addStats((IMaterialStats)new BowMaterialStats(100.0f, 3.0f, 8.0f));
            materialSpaceTimeDisruption.addStats((IMaterialStats)new BowStringMaterialStats(3.0f));
            materialSpaceTimeDisruption.addStats((IMaterialStats)new ArrowShaftMaterialStats(3.0f, 64));
            materialSpaceTimeDisruption.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialVoidSpar.addItem(ModItems.gemVoidSpar, 1, 144);
            materialVoidSpar.setCastable(false);
            materialVoidSpar.setCraftable(true);
            materialVoidSpar.setRepresentativeItem(ModItems.gemVoidSpar);
            materialVoidSpar.addTrait((ITrait)ModTraits.voidic);
            materialVoidSpar.addTrait((ITrait)TinkerTraits.dense);
            materialVoidSpar.addTrait((ITrait)TinkerTraits.ecological);
            materialVoidSpar.addStats((IMaterialStats)new HeadMaterialStats(50, 6.0f, 10.0f, 5));
            materialVoidSpar.addStats((IMaterialStats)new HandleMaterialStats(2.0f, -50));
            materialVoidSpar.addStats((IMaterialStats)new ExtraMaterialStats(2));
            materialVoidSpar.addStats((IMaterialStats)new ArrowShaftMaterialStats(1.0f, 10));
            materialVoidSpar.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialGarstone.addItem(ModItems.gemGarstone, 1, 144);
            materialGarstone.setCastable(false);
            materialGarstone.setCraftable(true);
            materialGarstone.setRepresentativeItem(ModItems.gemGarstone);
            materialGarstone.addTrait((ITrait)TinkerTraits.coldblooded);
            materialGarstone.addTrait((ITrait)TinkerTraits.jagged);
            materialGarstone.addTrait((ITrait)TinkerTraits.unnatural);
            materialGarstone.addStats((IMaterialStats)new HeadMaterialStats(50, 6.0f, 10.0f, 5));
            materialGarstone.addStats((IMaterialStats)new HandleMaterialStats(2.0f, -50));
            materialGarstone.addStats((IMaterialStats)new ExtraMaterialStats(2));
            materialGarstone.addStats((IMaterialStats)new ArrowShaftMaterialStats(1.0f, 10));
            materialGarstone.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialGravitonium.addItem("oreGravitonium", 1, Material.VALUE_Ore());
            materialGravitonium.addItem("oreGravitoniumDense", 1, Material.VALUE_Ore() * 4);
            materialGravitonium.setFluid(ModFluids.liquidGravitonium);
            materialGravitonium.addCommonItems("Gravitonium");
            materialGravitonium.setCastable(true);
            materialGravitonium.setCraftable(false);
            materialGravitonium.setRepresentativeItem("ingotGravitonium");
            materialGravitonium.addTrait((ITrait)ModTraits.hypergravity);
            materialGravitonium.addStats((IMaterialStats)new HeadMaterialStats(70, 6.0f, 4.0f, 5));
            if (CompatManager.plustic) {
                materialGravitonium.addStats((IMaterialStats)new LaserMediumMaterialStats(8.0f, 25.0f));
                materialGravitonium.addStats((IMaterialStats)new BatteryCellMaterialStats(480000));
            }
            materialGravitonium.addStats((IMaterialStats)new HandleMaterialStats(3.0f, 40));
            materialGravitonium.addStats((IMaterialStats)new ExtraMaterialStats(40));
            materialGravitonium.addStats((IMaterialStats)new ArrowShaftMaterialStats(3.0f, 20));
            materialGravitonium.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialGallium.addCommonItems("Gallium");
            materialGallium.setFluid(ModFluids.liquidGallium);
            materialGallium.setCastable(true);
            materialGallium.setCraftable(true);
            materialGallium.setRepresentativeItem("ingotGallium");
            materialGallium.addTrait((ITrait)TinkerTraits.aquadynamic);
            materialGallium.addTrait((ITrait)ModTraits.liquid);
            materialGallium.addTrait((ITrait)TinkerTraits.crumbling);
            materialGallium.addStats((IMaterialStats)new HeadMaterialStats(50, 6.0f, 10.0f, 5));
            materialGallium.addStats((IMaterialStats)new HandleMaterialStats(2.0f, -50));
            materialGallium.addStats((IMaterialStats)new ExtraMaterialStats(2));
            materialGallium.addStats((IMaterialStats)new ArrowShaftMaterialStats(1.0f, 10));
            materialGallium.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialRuneSteel.addCommonItems("RuneSteel");
            materialRuneSteel.setFluid(ModFluids.liquidRuneSteel);
            materialRuneSteel.setCastable(true);
            materialRuneSteel.setCraftable(false);
            materialRuneSteel.addTrait((ITrait)ModTraits.magical);
            materialRuneSteel.setRepresentativeItem("ingotRuneSteel");
            materialRuneSteel.addStats((IMaterialStats)new HeadMaterialStats(90, 18.0f, 14.0f, 7));
            materialRuneSteel.addStats((IMaterialStats)new HandleMaterialStats(4.0f, 60));
            materialRuneSteel.addStats((IMaterialStats)new ExtraMaterialStats(60));
            materialRuneSteel.addStats((IMaterialStats)new ArrowShaftMaterialStats(3.0f, 20));
            materialRuneSteel.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialEnderal.addItem(ModItems.gemEnderal, 1, 144);
            materialEnderal.setCastable(false);
            materialEnderal.setCraftable(true);
            materialEnderal.setRepresentativeItem(ModItems.gemEnderal);
            materialEnderal.addTrait((ITrait)TinkerTraits.enderference);
            materialEnderal.addTrait((ITrait)TinkerTraits.endspeed);
            materialEnderal.addTrait((ITrait)TinkerTraits.jagged);
            materialEnderal.addTrait((ITrait)ModTraits.pulsation);
            materialEnderal.addStats((IMaterialStats)new HeadMaterialStats(50, 6.0f, 10.0f, 5));
            materialEnderal.addStats((IMaterialStats)new HandleMaterialStats(2.0f, -50));
            materialEnderal.addStats((IMaterialStats)new ExtraMaterialStats(2));
            materialEnderal.addStats((IMaterialStats)new ArrowShaftMaterialStats(1.0f, 10));
            materialEnderal.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialEnderexamite.setCastable(false);
            materialEnderexamite.setCraftable(false);
            Materials.forceSetRepItem(new ItemStack(ModItems.repItemEnderexamite), materialEnderexamite);
            materialEnderexamite.addTrait((ITrait)TinkerTraits.slimeyBlue);
            materialEnderexamite.addTrait((ITrait)TinkerTraits.crumbling);
            materialEnderexamite.addTrait((ITrait)TinkerTraits.endspeed);
            materialEnderexamite.addTrait((ITrait)ModTraits.pulsation);
            materialEnderexamite.addTrait((ITrait)ModTraits.resilient);
            materialEnderexamite.addStats((IMaterialStats)new HeadMaterialStats(130, 7.0f, 11.0f, 5));
            materialEnderexamite.addStats((IMaterialStats)new HandleMaterialStats(2.25f, 20));
            materialEnderexamite.addStats((IMaterialStats)new ExtraMaterialStats(12));
            materialEnderexamite.addStats((IMaterialStats)new ArrowShaftMaterialStats(1.0f, 15));
            materialEnderexamite.addStats((IMaterialStats)new ProjectileMaterialStats());
            CompositeRegistry.registerComposite(materialEnderal, materialEnderexamite, (Fluid)TinkerFluids.knightslime);
            materialPlasma.addStats((IMaterialStats)new HeadMaterialStats(4096, 6.0f, 12.0f, 5));
            materialPlasma.addTrait((ITrait)ModTraits.plasmatic);
        }
        if (CompatManager.aether_legacy) {
            materialZanite.addItem("gemZanite", 1, 144);
            materialZanite.addItem("blockZanite", 1, 1296);
            materialZanite.setCastable(false);
            materialZanite.setCraftable(true);
            materialZanite.setRepresentativeItem("gemZanite");
            materialZanite.addTrait((ITrait)ModTraits.aetheric);
            materialZanite.addTrait((ITrait)ModTraits.treetap);
            materialZanite.addTrait((ITrait)TinkerTraits.jagged);
            materialZanite.addTrait((ITrait)ModTraits.hardcore);
            materialZanite.addStats((IMaterialStats)new HeadMaterialStats(210, 2.0f, 4.0f, 2));
            materialZanite.addStats((IMaterialStats)new HandleMaterialStats(0.9f, 65));
            materialZanite.addStats((IMaterialStats)new ExtraMaterialStats(50));
            materialSkyroot.addItem("plankWoodSkyroot", 1, 144);
            materialSkyroot.addItem("logWoodSkyroot", 1, 576);
            materialSkyroot.addItem("stickWoodSkyroot", 1, 72);
            materialSkyroot.setCastable(false);
            materialSkyroot.setCraftable(true);
            materialSkyroot.setRepresentativeItem("logWoodSkyroot");
            materialSkyroot.addTrait((ITrait)ModTraits.aetheric);
            materialSkyroot.addTrait((ITrait)ModTraits.rootplicating);
            materialSkyroot.addTrait((ITrait)TinkerTraits.ecological);
            materialSkyroot.addStats((IMaterialStats)new HeadMaterialStats(40, 2.0f, 2.0f, 0));
            materialSkyroot.addStats((IMaterialStats)new HandleMaterialStats(1.2f, 25));
            materialSkyroot.addStats((IMaterialStats)new ExtraMaterialStats(15));
            materialSkyroot.addStats((IMaterialStats)new BowMaterialStats(0.6f, 1.1f, 2.0f));
            materialSkyroot.addStats((IMaterialStats)new ArrowShaftMaterialStats(1.2f, 16));
            materialArkenium.addCommonItems("Arkenium");
            materialArkenium.setFluid(ModFluids.liquidArkenium);
            materialArkenium.setCastable(true);
            materialArkenium.setCraftable(false);
            materialArkenium.addTrait((ITrait)TinkerTraits.lightweight);
            materialArkenium.addTrait((ITrait)TinkerTraits.holy);
            materialArkenium.addTrait((ITrait)TinkerTraits.sharp);
            materialArkenium.addTrait((ITrait)ModTraits.aetheric);
            materialArkenium.setRepresentativeItem("ingotArkenium");
            materialArkenium.addStats((IMaterialStats)new HeadMaterialStats(1250, 10.0f, 5.25f, 4));
            materialArkenium.addStats((IMaterialStats)new HandleMaterialStats(1.1f, 100));
            materialArkenium.addStats((IMaterialStats)new ExtraMaterialStats(125));
            materialArkenium.addStats((IMaterialStats)new ArrowShaftMaterialStats(3.5f, 25));
            materialArkenium.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialValkyrieMetal.addCommonItems("ValkyrieMetal");
            materialValkyrieMetal.setFluid(ModFluids.liquidValkyrieMetal);
            materialValkyrieMetal.setCastable(true);
            materialValkyrieMetal.setCraftable(false);
            materialValkyrieMetal.addTrait((ITrait)ModTraits.reaching);
            materialValkyrieMetal.addTrait((ITrait)ModTraits.treetap);
            materialValkyrieMetal.addTrait((ITrait)ModTraits.aetheric);
            materialValkyrieMetal.setRepresentativeItem("ingotValkyrieMetal");
            materialValkyrieMetal.addStats((IMaterialStats)new HeadMaterialStats(1250, 10.0f, 5.25f, 4));
            materialValkyrieMetal.addStats((IMaterialStats)new HandleMaterialStats(1.1f, 100));
            materialValkyrieMetal.addStats((IMaterialStats)new ExtraMaterialStats(125));
            materialValkyrieMetal.addStats((IMaterialStats)new ArrowShaftMaterialStats(3.5f, 25));
            materialValkyrieMetal.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialHolystone.addItem("holystone", 1, 144);
            materialHolystone.setCastable(false);
            materialHolystone.setCraftable(true);
            materialHolystone.setRepresentativeItem("holystone");
            materialHolystone.addTrait((ITrait)TinkerTraits.cheapskate);
            materialHolystone.addTrait((ITrait)ModTraits.aetheric);
            materialHolystone.addTrait((ITrait)ModTraits.blessed);
            materialHolystone.addStats((IMaterialStats)new HeadMaterialStats(130, 3.0f, 3.0f, 1));
            materialHolystone.addStats((IMaterialStats)new HandleMaterialStats(0.25f, -50));
            materialHolystone.addStats((IMaterialStats)new ExtraMaterialStats(30));
            materialGravitite.addItem("blockGravitite", 1, 1296);
            materialGravitite.addItem("gemGravitite", 1, 144);
            materialGravitite.setCastable(false);
            materialGravitite.setCraftable(true);
            materialGravitite.setRepresentativeItem("gemGravitite");
            materialGravitite.addTrait((ITrait)TinkerTraits.insatiable);
            materialGravitite.addTrait((ITrait)ModTraits.antigravity);
            materialGravitite.addTrait((ITrait)ModTraits.treetap);
            materialGravitite.addStats((IMaterialStats)new HeadMaterialStats(950, 7.5f, 5.0f, 3));
            materialGravitite.addStats((IMaterialStats)new HandleMaterialStats(0.9f, 90));
            materialGravitite.addStats((IMaterialStats)new ExtraMaterialStats(90));
        }
        if (CompatManager.twilightforest) {
            materialIronwood.addCommonItems("Ironwood");
            materialIronwood.setCastable(true);
            materialIronwood.setFluid(ModFluids.liquidIronwood);
            materialIronwood.setCraftable(false);
            materialIronwood.setRepresentativeItem("ingotIronwood");
            materialIronwood.addTrait((ITrait)TConstruct.twilit);
            materialIronwood.addTrait((ITrait)TinkerTraits.ecological);
            materialIronwood.addStats((IMaterialStats)new HeadMaterialStats(100, 10.0f, 5.0f, 4));
            materialIronwood.addStats((IMaterialStats)new HandleMaterialStats(1.0f, 25));
            materialIronwood.addStats((IMaterialStats)new ExtraMaterialStats(25));
            materialIronwood.addStats((IMaterialStats)new ArrowShaftMaterialStats(1.0f, 1));
            materialIronwood.addStats((IMaterialStats)new ProjectileMaterialStats());
            Materials.forceSetRepItem(new ItemStack(ModItems.repItemFerroherb), materialFerroherb);
            materialFerroherb.setCastable(false);
            materialFerroherb.setCraftable(false);
            CompositeRegistry.registerComposite(TConstruct.steeleaf, materialFerroherb, ModFluids.liquidIronwood);
            materialFerroherb.addTrait((ITrait)TConstruct.synergy);
            materialFerroherb.addTrait((ITrait)TConstruct.twilit);
            materialFerroherb.addTrait((ITrait)TinkerTraits.ecological);
            materialFerroherb.addTrait((ITrait)TinkerTraits.sharp);
            materialFerroherb.addTrait((ITrait)TinkerTraits.splintering);
            materialFerroherb.addStats((IMaterialStats)new HeadMaterialStats(200, 10.0f, 7.0f, 4));
            materialFerroherb.addStats((IMaterialStats)new HandleMaterialStats(1.125f, 100));
            materialFerroherb.addStats((IMaterialStats)new ExtraMaterialStats(125));
            materialFerroherb.addStats((IMaterialStats)new ArrowShaftMaterialStats(1.0f, 25));
            materialFerroherb.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialPenguinite.addCommonItems("Penguinite");
            materialPenguinite.setCastable(true);
            materialPenguinite.setFluid(ModFluids.liquidPenguinite);
            materialPenguinite.setCraftable(false);
            materialPenguinite.setRepresentativeItem("ingotPenguinite");
            materialPenguinite.addTrait((ITrait)TConstruct.twilit);
            materialPenguinite.addTrait((ITrait)TinkerTraits.coldblooded);
            materialPenguinite.addTrait((ITrait)TinkerTraits.freezing);
            materialPenguinite.addStats((IMaterialStats)new HeadMaterialStats(100, 10.0f, 7.0f, 4));
            materialPenguinite.addStats((IMaterialStats)new HandleMaterialStats(1.0f, 25));
            materialPenguinite.addStats((IMaterialStats)new ExtraMaterialStats(25));
            materialPenguinite.addStats((IMaterialStats)new ArrowShaftMaterialStats(1.0f, 1));
            materialPenguinite.addStats((IMaterialStats)new ProjectileMaterialStats());
        }
        if (CompatManager.thebetweenlands) {
            materialSyrmorite.addItem("oreSyrmorite", 1, Material.VALUE_Ore());
            materialSyrmorite.setFluid(ModFluids.liquidSyrmorite);
            materialSyrmorite.addCommonItems("Syrmorite");
            materialSyrmorite.setCastable(true);
            materialSyrmorite.setCraftable(false);
            materialSyrmorite.setRepresentativeItem("ingotSyrmorite");
            materialSyrmorite.addTrait((ITrait)TinkerTraits.dense);
            materialSyrmorite.addTrait((ITrait)TinkerTraits.magnetic);
            materialSyrmorite.addStats((IMaterialStats)new HeadMaterialStats(800, 5.0f, 4.0f, 2));
            materialSyrmorite.addStats((IMaterialStats)new HandleMaterialStats(1.125f, -50));
            materialSyrmorite.addStats((IMaterialStats)new ExtraMaterialStats(-25));
            materialSyrmorite.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialOctine.addItem("oreOctine", 1, Material.VALUE_Ore());
            materialOctine.setFluid(ModFluids.liquidOctine);
            materialOctine.addCommonItems("Octine");
            materialOctine.setCastable(true);
            materialOctine.setCraftable(false);
            materialOctine.setRepresentativeItem("ingotOctine");
            materialOctine.addTrait((ITrait)TinkerTraits.superheat);
            materialOctine.addTrait((ITrait)ModTraits.burning);
            materialOctine.addStats((IMaterialStats)new HeadMaterialStats(900, 5.0f, 4.0f, 2));
            materialOctine.addStats((IMaterialStats)new HandleMaterialStats(1.25f, -50));
            materialOctine.addStats((IMaterialStats)new ExtraMaterialStats(-25));
            materialOctine.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialOctine.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialValonite.addItem("gemValonite", 1, 144);
            materialValonite.addItem("blockValonite", 1, 1296);
            materialValonite.addItem("nuggetValonite", 1, 16);
            materialValonite.setCastable(false);
            materialValonite.setCraftable(true);
            materialValonite.setRepresentativeItem("gemValonite");
            materialValonite.addTrait((ITrait)TinkerTraits.dense);
            materialValonite.addTrait((ITrait)TinkerTraits.sharp);
            materialValonite.addStats((IMaterialStats)new HeadMaterialStats(975, 6.0f, 6.125f, 3));
            materialValonite.addStats((IMaterialStats)new HandleMaterialStats(1.0f, -75));
            materialValonite.addStats((IMaterialStats)new ExtraMaterialStats(-25));
            materialValonite.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialSlimyBone.addItem("gemSlimyBone", 1, 144);
            materialSlimyBone.addItem("blockSlimyBone", 1, 1296);
            materialSlimyBone.setCastable(false);
            materialSlimyBone.setCraftable(true);
            materialSlimyBone.setRepresentativeItem("gemSlimyBone");
            materialSlimyBone.addTrait((ITrait)TinkerTraits.splintering);
            materialSlimyBone.addTrait((ITrait)TinkerTraits.cheap);
            materialSlimyBone.addTrait((ITrait)TinkerTraits.cheapskate);
            materialSlimyBone.addTrait((ITrait)TinkerTraits.crude);
            materialSlimyBone.addStats((IMaterialStats)new HeadMaterialStats(275, 3.0f, 3.0f, 1));
            materialSlimyBone.addStats((IMaterialStats)new HandleMaterialStats(1.1f, 25));
            materialSlimyBone.addStats((IMaterialStats)new ExtraMaterialStats(5));
            materialReedRope.addItem("ropeReed", 1, 144);
            materialReedRope.setCastable(false);
            materialReedRope.setCraftable(true);
            materialReedRope.setRepresentativeItem("ropeReed");
            materialReedRope.addTrait((ITrait)TinkerTraits.ecological);
            materialReedRope.addTrait((ITrait)TinkerTraits.aquadynamic);
            materialReedRope.addTrait((ITrait)TinkerTraits.writable2);
            materialReedRope.addStats((IMaterialStats)new BowStringMaterialStats(2.0f));
            materialReedRope.addStats((IMaterialStats)new FletchingMaterialStats(0.85f, 4.0f));
            materialDragonFlyWing.addItem("itemDragonFlyWing", 1, 144);
            materialDragonFlyWing.setCastable(false);
            materialDragonFlyWing.setCraftable(true);
            materialDragonFlyWing.setRepresentativeItem("itemDragonFlyWing");
            materialDragonFlyWing.addTrait((ITrait)TinkerTraits.lightweight);
            materialDragonFlyWing.addStats((IMaterialStats)new FletchingMaterialStats(1.0f, 4.0f));
            materialAnglerTooth.addItem("itemAnglerTooth", 1, 144);
            materialAnglerTooth.setCastable(false);
            materialAnglerTooth.setCraftable(true);
            materialAnglerTooth.setRepresentativeItem("itemAnglerTooth");
            materialAnglerTooth.addTrait((ITrait)TinkerTraits.aquadynamic);
            materialAnglerTooth.addTrait((ITrait)TinkerTraits.jagged);
            materialAnglerTooth.addStats((IMaterialStats)new ProjectileMaterialStats());
            materialAnglerTooth.addStats((IMaterialStats)new HeadMaterialStats(128, 2.0f, 5.0f, 1));
            materialWeedwood.addItem("plankWoodWeedwood", 1, 144);
            materialWeedwood.addItem("logWoodWeedwood", 1, 576);
            materialWeedwood.addItem("stickWoodWeedwood", 1, 72);
            materialWeedwood.setCastable(false);
            materialWeedwood.setCraftable(true);
            materialWeedwood.setRepresentativeItem("logWoodWeedwood");
            materialWeedwood.addTrait((ITrait)TinkerTraits.ecological);
            materialWeedwood.addStats((IMaterialStats)new HeadMaterialStats(40, 2.0f, 2.0f, 0));
            materialWeedwood.addStats((IMaterialStats)new HandleMaterialStats(1.2f, 25));
            materialWeedwood.addStats((IMaterialStats)new ExtraMaterialStats(15));
            materialWeedwood.addStats((IMaterialStats)new BowMaterialStats(0.8f, 1.1f, 2.0f));
            materialWeedwood.addStats((IMaterialStats)new ArrowShaftMaterialStats(1.2f, 16));
            materialShockwave.addStats((IMaterialStats)new HeadMaterialStats(1256, 6.0f, 6.125f, 3));
            materialShockwave.addTrait((ITrait)ModTraits.shockwaving);
        }
    }
}

