/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.materials;

import com.existingeevee.moretcon.materials.Materials;
import com.existingeevee.moretcon.other.DoubleValue;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.book.content.ContentMaterial;
import slimeknights.tconstruct.library.book.sectiontransformer.AbstractMaterialSectionTransformer;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.tools.modifiers.ModExtraTrait;

public class UniqueMaterial
extends Material {
    public static final Map<String, DoubleValue<UniqueMaterial, String>> uniqueMaterials = new HashMap<String, DoubleValue<UniqueMaterial, String>>();
    public String toolResLoc;
    public String partResLoc;

    public UniqueMaterial(String identifier, int color, ToolPart part, ToolCore tool) {
        this(identifier, color);
        this.partResLoc = part.getRegistryName().toString();
        this.toolResLoc = tool.getRegistryName().toString();
        uniqueMaterials.put(this.identifier, new DoubleValue<UniqueMaterial, String>(this, part.getRegistryName().toString()));
    }

    public UniqueMaterial(String identifier, int color, String part, String tool) {
        this(identifier, color);
        this.partResLoc = new ResourceLocation(part).toString();
        this.toolResLoc = new ResourceLocation(tool).toString();
        uniqueMaterials.put(this.identifier, new DoubleValue<UniqueMaterial, String>(this, part));
    }

    private UniqueMaterial(String identifier, int color) {
        super(identifier, color, false);
        this.setCastable(false);
        this.setCraftable(false);
    }

    public ItemStack getUniqueToolPart() {
        return UniqueMaterial.getToolPartFromResourceLocation(new ResourceLocation(this.partResLoc)).getItemstackWithMaterial((Material)this);
    }

    public String getLocalizedName() {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        try {
            if (stacktrace[3].getClassName().equals(AbstractMaterialSectionTransformer.class.getName()) && stacktrace[3].getLineNumber() == 67) {
                return I18n.func_74838_a((String)"material.uniquetoolpart.name") + " (" + I18n.func_74838_a((String)("uniquetoolpart." + this.getIdentifier() + ".name")) + ")";
            }
            if (stacktrace[3].getClassName().equals(ContentMaterial.class.getName()) && stacktrace[3].getLineNumber() == 64) {
                return I18n.func_74838_a((String)"material.uniquetoolpart.name") + " (" + I18n.func_74838_a((String)("uniquetoolpart." + this.getIdentifier() + ".name")) + ")";
            }
            if (stacktrace[2].getClassName().equals(ModExtraTrait.class.getName()) && stacktrace[2].getLineNumber() == 106) {
                return "a " + I18n.func_74838_a((String)("uniquetoolpart." + this.getIdentifier() + ".name")) + " " + I18n.func_74838_a((String)(UniqueMaterial.getToolPartFromResourceLocation(new ResourceLocation(this.partResLoc)).func_77658_a() + ".name"));
            }
            if (stacktrace[2].getClassName().equals(ModExtraTrait.class.getName()) && stacktrace[2].getLineNumber() == 101) {
                return I18n.func_74838_a((String)("uniquetoolpart." + this.getIdentifier() + ".name"));
            }
            if (stacktrace[3].getClassName().equals(ToolPart.class.getName()) && stacktrace[3].getLineNumber() == 203) {
                return I18n.func_74838_a((String)"material.uniquetoolpart.name") + " (" + I18n.func_74838_a((String)("uniquetoolpart." + this.getIdentifier() + ".name")) + ")";
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return I18n.func_74838_a((String)"material.uniquetoolpart.name");
    }

    public static ToolPart getToolPartFromResourceLocation(ResourceLocation res) {
        for (IToolPart part : TinkerRegistry.getToolParts()) {
            if (!(part instanceof Item) || !((Item)part).getRegistryName().equals((Object)res)) continue;
            return (ToolPart)part;
        }
        return null;
    }

    public static ToolCore getToolFromResourceLocation(ResourceLocation res) {
        for (ToolCore tool : TinkerRegistry.getTools()) {
            if (!tool.getRegistryName().equals((Object)res)) continue;
            return tool;
        }
        return null;
    }

    public static void onPostInit() {
        for (DoubleValue<UniqueMaterial, String> mat : uniqueMaterials.values()) {
            if (!(mat.getA() instanceof UniqueMaterial) || TinkerRegistry.getMaterial((String)mat.getA().getIdentifier()).getIdentifier().equals(Material.UNKNOWN.getIdentifier())) continue;
            Materials.forceSetRepItem(mat.getA().getUniqueToolPart(), mat.getA());
        }
    }
}

