/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.other;

import com.existingeevee.moretcon.other.Logging;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ConfigHandler {
    public static File configFile;
    public static Configuration config;
    public static boolean useLegacyModID;
    public static boolean shouldAllowJokeItems;
    public static boolean shouldAllowTwilightForest;
    public static boolean shouldAllowIceAndFire;
    public static boolean shouldAllowPlusTiC;
    public static boolean shouldAllowBetweenLands;
    public static boolean shouldLoadDust;
    public static boolean shouldLoadDustForCompatability;
    public static boolean disableOreGen;
    public static boolean weakenToolsInBetweenLands;
    public static boolean registerBetweenTinkerTools;
    public static String[] blacklist;
    public static boolean shouldAllowMainContent;
    public static boolean shouldAllowOreDictionary;
    public static boolean shouldAllowCrossCompat;
    public static boolean shouldAllowAether;
    public static boolean shouldUseResistanceInTrichromic;

    public static void initConfig(File file) {
        config = new Configuration(file, "1.5.0_2");
        config.load();
        String category = "Allow Loading";
        config.addCustomCategoryComment(category, "Allows the loading of certain mod compatibilities.");
        shouldAllowTwilightForest = config.getBoolean("twilightforest", category, true, "Set to \"false\" if you want to not want to allow Twilight Forest Compatibility to load.");
        shouldAllowIceAndFire = config.getBoolean("iceandfire", category, true, "[NYI] Set to \"false\" if you want to not want to allow Ice and Fire Compatibility to load.");
        shouldAllowPlusTiC = config.getBoolean("plustic", category, true, "Set to \"false\" if you want to not want to allow PlusTiC Compatibility to load.");
        shouldAllowBetweenLands = config.getBoolean("thebetweenlands", category, true, "Set to \"false\" if you want to not want to allow Betweenlands Compatibility to load.");
        shouldAllowJokeItems = config.getBoolean("jokes", category, true, "[NYI] Set to \"false\" if you want to not want to allow Easter Eggs and Jokes to load.");
        shouldAllowOreDictionary = config.getBoolean("oredict", category, true, "[NYI] Set to \"false\" if you want to not want to allow the mod to use ore dictionary for materials.");
        shouldAllowCrossCompat = config.getBoolean("crosscompat", category, true, "[NYI] Set to \"false\" if you want to not want to allow cross compatibility between mods to load.");
        shouldAllowMainContent = config.getBoolean("main", category, true, "Set to \"false\" if you want to not want to allow things from the main mod to load.");
        shouldAllowAether = config.getBoolean("aether", category, true, "Set to \"false\" if you want to not want to allow Aether Compatibility to load.");
        category = "Misc";
        config.addCustomCategoryComment(category, "Tweak the miscellaneous values/content of the mod");
        shouldLoadDust = config.getBoolean("allowdust", category, false, "Set to \"true\" if you want to load dust.");
        shouldLoadDustForCompatability = config.getBoolean("compatdust", category, true, "Set to \"false\" if you do not want to load dust for other mods.");
        disableOreGen = config.getBoolean("disableoregen", category, false, "Set to \"true\" if you want to remove world generation");
        weakenToolsInBetweenLands = config.getBoolean("weakennonbetweentinkers", category, true, "Set to \"false\" if you do not want to weaken non BetweenTinker tinker items.");
        registerBetweenTinkerTools = config.getBoolean("registerBetweenTinkerTools".toLowerCase(), category, true, "Set to \"false\" if you do not want to  BetweenTinker tinker items to be loaded.");
        shouldUseResistanceInTrichromic = config.getBoolean("shouldUseResistanceInTrichromic".toLowerCase(), category, false, "Set to \"true\" if you want to have Blue Trichromic use resistance as absorption breaks when using other mods that mess with it.");
        category = "Blacklist";
        config.addCustomCategoryComment(category, "Remove some of the added materials. Example: \"materialfusionite\"");
        String[] blacklist = new String[]{"materialexample"};
        ConfigHandler.blacklist = config.getStringList("blacklist", category, blacklist, "Add materials to blacklist");
        config.save();
        Logging.log("Finished Reading Config.");
    }

    public static void init(FMLPreInitializationEvent event) {
        configFile = new File(event.getModConfigurationDirectory() + "/" + "moretcon");
        configFile.mkdirs();
        ConfigHandler.initConfig(new File(configFile.getPath(), "moretcon.cfg"));
    }

    static {
        useLegacyModID = false;
        shouldAllowJokeItems = true;
        shouldAllowTwilightForest = true;
        shouldAllowIceAndFire = false;
        shouldAllowPlusTiC = true;
        shouldAllowBetweenLands = true;
        shouldLoadDust = false;
        shouldLoadDustForCompatability = true;
        disableOreGen = false;
        weakenToolsInBetweenLands = true;
        registerBetweenTinkerTools = true;
        blacklist = new String[]{"materialExample"};
        shouldAllowMainContent = true;
        shouldAllowOreDictionary = true;
        shouldAllowCrossCompat = true;
        shouldAllowAether = true;
        shouldUseResistanceInTrichromic = false;
    }
}

