/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.other;

import com.existingeevee.moretcon.block.blocktypes.BlockOre;
import com.existingeevee.moretcon.block.blocktypes.BlockOreMetal;
import com.existingeevee.moretcon.item.ItemBase;
import com.existingeevee.moretcon.other.ConfigHandler;
import com.existingeevee.moretcon.other.RenderHandler;
import com.existingeevee.moretcon.other.sponge.SpongeRegistry;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.common.ModelRegisterUtil;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolPart;

public class RegisterHelper {
    public static List<MaterialIntegration> moreTConIntegrations = new ArrayList<MaterialIntegration>();
    public static List<ToolCore> moreTConTools = new ArrayList<ToolCore>();
    public static List<Modifier> moreTConModifiers = new ArrayList<Modifier>();

    public static void registerBlock(Block block) {
        RegisterHelper.registerBlock(block, (Function<Block, ItemBlock>)((Function)ItemBlock::new));
    }

    public static void registerBlock(Block block, @Nullable Function<Block, ItemBlock> itemBlock) {
        String name = block.func_149739_a().substring(5);
        ForgeRegistries.BLOCKS.register(block.setRegistryName(name));
        if (itemBlock != null) {
            ForgeRegistries.ITEMS.register(((ItemBlock)itemBlock.apply((Object)block)).setRegistryName(block.getRegistryName()));
            try {
                RegisterHelper.registerBlockModel(block);
                if (block instanceof BlockFluidClassic) {
                    RenderHandler.registerFluidCustomMeshesAndStates(block);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (block instanceof BlockOre) {
            GameRegistry.addSmelting((Block)block, (ItemStack)((BlockOre)block).getOreDrop(), (float)10.0f);
        } else if (block instanceof BlockOreMetal) {
            GameRegistry.addSmelting((Block)block, (ItemStack)((BlockOreMetal)block).getOreDrop(), (float)10.0f);
        }
    }

    public static void registerTileEntity(Class<? extends TileEntity> tileClass) {
        GameRegistry.registerTileEntity(tileClass, (ResourceLocation)new ResourceLocation("moretcon", tileClass.getSimpleName()));
    }

    public static void registerItem(Item item) {
        String name = item.func_77658_a().substring(5);
        if (item instanceof ItemBase) {
            item.func_77637_a(((ItemBase)item).getTab());
        }
        item.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        try {
            if (item instanceof ToolCore) {
                ModelRegisterUtil.registerToolModel((ToolCore)((ToolCore)item));
                moreTConTools.add((ToolCore)item);
            } else if (item instanceof ToolPart) {
                ModelRegisterUtil.registerPartModel((Item)((ToolPart)item));
            } else if (item instanceof SpongeRegistry.GravitoniumSpongeItem) {
                RenderHandler.registerSponge((SpongeRegistry.GravitoniumSpongeItem)item);
            } else {
                RegisterHelper.registerItemModel(item);
            }
        }
        catch (NoSuchMethodError e) {
            return;
        }
        catch (NoClassDefFoundError e) {
            return;
        }
    }

    public static void registerBiome(Biome biome) {
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
    }

    public static boolean registerMaterial(Material material, Fluid fluid, String suffix, boolean bypassCheck) {
        List<String> list = Arrays.asList(ConfigHandler.blacklist);
        if (!list.contains(material.getIdentifier()) || bypassCheck) {
            RegisterHelper.integrate(material, fluid, suffix);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("moretcon:" + item.func_77658_a().substring(5), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockModel(Block block) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation("moretcon:" + block.func_149739_a().substring(5), "inventory"));
    }

    public static void registerModifier(IModifier modifier) {
        moreTConModifiers.add((Modifier)modifier);
    }

    private static void integrate(Material material, Fluid fluid, String suffix) {
        moreTConIntegrations.add(new MaterialIntegration(material, fluid, suffix));
    }

    public static void registerFluid(Fluid fluid) {
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
    }
}

