/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.other.sponge;

import com.existingeevee.moretcon.item.ItemBase;
import com.existingeevee.moretcon.other.OreDictionaryManager;
import com.existingeevee.moretcon.other.sponge.ModSponges;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;

public class SpongeRegistry {
    private static final SpongeRegistry instance = new SpongeRegistry();
    private static Map<String, SpongeRecipe> recipes = new HashMap<String, SpongeRecipe>();

    private SpongeRegistry() {
    }

    public static void postInit() {
        for (Map.Entry<String, SpongeRecipe> s : recipes.entrySet()) {
            OreDictionaryManager.registerOre(s.getValue().resultOreDict, s.getValue().result);
            GameRegistry.addSmelting((ItemStack)new ItemStack((Item)s.getValue().result, 1), (ItemStack)s.getValue().smeltResult.func_77946_l(), (float)0.0f);
            int i = 0;
            for (SpongeStep s2 : s.getValue().steps) {
                ItemStack input = new ItemStack(ModSponges.gravitoniumSponge);
                ItemStack output = new ItemStack((Item)s.getValue().result);
                if (i != 0) {
                    input = new ItemStack((Item)s.getValue().result, 1, i);
                }
                if (i + 1 != s.getValue().steps.length) {
                    output = new ItemStack((Item)s.getValue().result, 1, i + 1);
                }
                TinkerRegistry.registerBasinCasting((ICastingRecipe)new CastingRecipe(output, RecipeMatch.of((ItemStack)input, (int)1), new FluidStack(FluidRegistry.getFluid((String)s2.fluidName), s2.fluidAmount), 200, true, true));
                ++i;
            }
        }
    }

    public static GravitoniumSpongeItem getSponge(SpongeRecipe sponge) {
        SpongeRegistry spongeRegistry = instance;
        spongeRegistry.getClass();
        return spongeRegistry.new GravitoniumSpongeItem(sponge);
    }

    public static SpongeRecipe createSpongeRecipe(String recipeName, String resultOreDict, ItemStack smeltResult, SpongeStep ... steps) {
        SpongeRegistry spongeRegistry = instance;
        spongeRegistry.getClass();
        return spongeRegistry.new SpongeRecipe(recipeName, resultOreDict, smeltResult, steps);
    }

    public static SpongeStep createSpongeStep(String fluid, int amount) {
        SpongeRegistry spongeRegistry = instance;
        spongeRegistry.getClass();
        return spongeRegistry.new SpongeStep(fluid, amount);
    }

    public static SpongeStep createSpongeStep(Fluid fluid, int amount) {
        SpongeRegistry spongeRegistry = instance;
        spongeRegistry.getClass();
        return spongeRegistry.new SpongeStep(fluid, amount);
    }

    public class GravitoniumSpongeItem
    extends ItemBase {
        public SpongeRecipe recipe;

        private GravitoniumSpongeItem(SpongeRecipe recipe) {
            super("item" + recipe.recipeName + "sponge");
            this.recipe = recipe;
            this.recipe.result = this;
            this.func_77627_a(true);
            this.func_77656_e(0);
            recipes.put(recipe.recipeName, recipe);
        }

        public SpongeRecipe getRecipe() {
            return this.recipe;
        }

        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
            if (this.func_194125_a(tab)) {
                for (int i = 1; i < this.recipe.steps.length; ++i) {
                    items.add((Object)new ItemStack((Item)this, 1, i));
                }
                items.add((Object)new ItemStack((Item)this, 1, 0));
            }
        }

        public String func_77653_i(ItemStack stack) {
            if (stack.func_77960_j() == 0) {
                return I18n.func_74838_a((String)"spongestatus.completed.name") + " " + I18n.func_74838_a((String)("spongerecipe." + this.recipe.recipeName + ".name")) + " " + I18n.func_74838_a((String)(ModSponges.gravitoniumSponge.func_77658_a() + ".name"));
            }
            return I18n.func_74838_a((String)"spongestatus.partial.name") + " (" + I18n.func_74838_a((String)"sponge.step.name") + " " + stack.func_77960_j() + ") " + I18n.func_74838_a((String)("spongerecipe." + this.recipe.recipeName + ".name")) + " " + I18n.func_74838_a((String)(ModSponges.gravitoniumSponge.func_77658_a() + ".name"));
        }
    }

    public class SpongeStep {
        private String fluidName;
        private int fluidAmount;

        public SpongeStep(String fluid, int amount) {
            this.fluidName = fluid;
            this.fluidAmount = amount;
        }

        public SpongeStep(Fluid fluid, int amount) {
            this.fluidName = fluid.getName();
            this.fluidAmount = amount;
        }
    }

    public class SpongeRecipe {
        public SpongeStep[] steps;
        private String resultOreDict;
        private ItemStack smeltResult;
        private String recipeName;
        private GravitoniumSpongeItem result;

        public SpongeRecipe(String recipeName, String resultOreDict, ItemStack smeltResult, SpongeStep ... steps) {
            this.resultOreDict = resultOreDict;
            this.smeltResult = smeltResult;
            this.steps = steps;
            this.recipeName = recipeName;
        }

        public ItemStack getSmeltResult() {
            return this.smeltResult;
        }

        public void setSmeltResult(ItemStack smeltResult) {
            this.smeltResult = smeltResult;
        }

        public String getResultOreDict() {
            return this.resultOreDict;
        }

        public void setResultOreDict(String resultOreDict) {
            this.resultOreDict = resultOreDict;
        }

        public int getStepAmount() {
            return this.steps.length;
        }

        public ArrayList<SpongeStep> getSteps() {
            ArrayList<SpongeStep> steps = new ArrayList<SpongeStep>();
            steps.addAll(steps);
            return steps;
        }
    }
}

