/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.tools.tooltypes;

import com.existingeevee.moretcon.other.betweenlands.IBetweenTinkerTool;
import com.existingeevee.moretcon.tools.CrashyBLItems;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import thebetweenlands.api.item.CorrosionHelper;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.api.item.ICorrodible;

public class BetweenAxe
extends AoeToolCore
implements ICorrodible,
IAnimatorRepairable,
IBetweenTinkerTool {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_150471_bO, Blocks.field_150452_aw});
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151575_d, (Object)Material.field_151582_l, (Object)Material.field_151585_k, (Object)Material.field_151572_C, (Object)Material.field_151570_A);

    public BetweenAxe() {
        this(PartMaterialType.handle((IToolPart)TinkerTools.toolRod), PartMaterialType.head((IToolPart)CrashyBLItems.betweenAxeHead), PartMaterialType.extra((IToolPart)TinkerTools.binding));
        this.func_77655_b("blaxe");
        TinkerRegistry.registerToolCrafting((ToolCore)this);
        CorrosionHelper.addCorrosionPropertyOverrides((Item)this);
    }

    protected BetweenAxe(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(new Category[]{Category.HARVEST});
        this.addCategory(new Category[]{Category.WEAPON});
        this.setHarvestLevel("axe", 0);
    }

    public boolean isEffective(IBlockState state) {
        return effective_materials.contains((Object)state.func_185904_a()) || EFFECTIVE_ON.contains(state.func_177230_c());
    }

    public float damagePotential() {
        return 1.1f;
    }

    public boolean isRepairableByAnimator(ItemStack stack) {
        return true;
    }

    public double attackSpeed() {
        return 1.1f;
    }

    public float knockback() {
        return 1.3f;
    }

    public void afterBlockBreak(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase player, int damage, boolean wasEffective) {
        if (state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos)) {
            damage = 0;
        }
        super.afterBlockBreak(stack, world, state, pos, player, damage, wasEffective);
    }

    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        boolean hit = super.dealDamage(stack, player, entity, damage);
        if (hit && this.readyForSpecialAttack(player)) {
            TinkerTools.proxy.spawnAttackParticle(Particles.HATCHET_ATTACK, (Entity)player, 0.8);
        }
        return hit;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return true;
    }

    protected ToolNBT buildTagData(List<slimeknights.tconstruct.library.materials.Material> materials) {
        ToolNBT data = this.buildDefaultTag(materials);
        data.attack += 0.5f;
        return data;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        float str = material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l ? super.func_150893_a(stack, state) : ToolHelper.calcDigSpeed((ItemStack)stack, (IBlockState)state);
        str = CorrosionHelper.getDestroySpeed((float)str, (ItemStack)stack, (IBlockState)state);
        return str;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return CorrosionHelper.shouldCauseBlockBreakReset((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return CorrosionHelper.shouldCauseReequipAnimation((ItemStack)oldStack, (ItemStack)newStack, (boolean)slotChanged);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity holder, int slot, boolean isHeldItem) {
        super.func_77663_a(itemStack, world, holder, slot, isHeldItem);
        CorrosionHelper.updateCorrosion((ItemStack)itemStack, (World)world, (Entity)holder, (int)slot, (boolean)isHeldItem);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND && !ToolHelper.isBroken((ItemStack)stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)ToolHelper.getActualAttack((ItemStack)stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)ToolHelper.getActualAttackSpeed((ItemStack)stack) - 4.0, 0));
        }
        TinkerUtil.getTraitsOrdered((ItemStack)stack).forEach(trait -> trait.getAttributeModifiers(slot, stack, multimap));
        return CorrosionHelper.getAttributeModifiers((Multimap)multimap, (EntityEquipmentSlot)slot, (ItemStack)stack, (UUID)field_111210_e, (float)ToolHelper.getActualAttack((ItemStack)stack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean shift = Util.isShiftKeyDown();
        boolean ctrl = Util.isCtrlKeyDown();
        if (!shift && !ctrl) {
            CorrosionHelper.addCorrosionTooltips((ItemStack)stack, tooltip, (boolean)flagIn.func_194127_a());
            tooltip.add("");
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public int getMinRepairFuelCost(ItemStack stack) {
        return Math.round(stack.func_77958_k() / 120) + 1;
    }

    public int getFullRepairFuelCost(ItemStack stack) {
        return Math.round(stack.func_77958_k() / 75) + 1;
    }

    public int getFullRepairLifeCost(ItemStack arg0) {
        return Math.round(arg0.func_77958_k() / 75) + 1;
    }

    public int getMinRepairLifeCost(ItemStack arg0) {
        return Math.round(arg0.func_77958_k() / 60) + 1;
    }
}

