/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.tools.tooltypes;

import com.existingeevee.moretcon.other.betweenlands.IBetweenTinkerTool;
import com.existingeevee.moretcon.tools.CrashyBLItems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.crosshair.Crosshairs;
import slimeknights.tconstruct.library.client.crosshair.ICrosshair;
import slimeknights.tconstruct.library.client.crosshair.ICustomCrosshairUser;
import slimeknights.tconstruct.library.events.ProjectileEvent;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ranged.BowCore;
import slimeknights.tconstruct.library.tools.ranged.IAmmo;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;
import thebetweenlands.api.item.CorrosionHelper;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.api.item.ICorrodible;

public class BetweenBow
extends BowCore
implements ICorrodible,
IAnimatorRepairable,
IBetweenTinkerTool,
ICustomCrosshairUser {
    public static final float DURABILITY_MODIFIER = 1.1f;

    public BetweenBow() {
        super(new PartMaterialType[]{PartMaterialType.bow((IToolPart)CrashyBLItems.betweenBowLimb), PartMaterialType.bow((IToolPart)CrashyBLItems.betweenBowLimb), PartMaterialType.bowstring((IToolPart)TinkerTools.bowString)});
        this.func_77655_b("blbow");
        this.func_185043_a(PROPERTY_PULL_PROGRESS, this.pullProgressPropertyGetter);
        this.func_185043_a(PROPERTY_IS_PULLING, this.isPullingPropertyGetter);
        TinkerRegistry.registerToolCrafting((ToolCore)this);
        CorrosionHelper.addCorrosionPropertyOverrides((Item)this);
        this.addCategory(new Category[]{Category.WEAPON});
    }

    public int[] getRepairParts() {
        return new int[]{0, 1};
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List)subItems, new Material[]{null, null, TinkerMaterials.string});
        }
    }

    public float baseProjectileDamage() {
        return 0.0f;
    }

    public float damagePotential() {
        return 0.7f;
    }

    public double attackSpeed() {
        return 1.5;
    }

    protected float baseInaccuracy() {
        return 1.0f;
    }

    public float projectileDamageModifier() {
        return 0.8f;
    }

    public int getDrawTime() {
        return 12;
    }

    protected List<Item> getAmmoItems() {
        return TinkerRangedWeapons.getDiscoveredArrows();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.preventSlowDown(entityIn, 0.5f);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        CorrosionHelper.updateCorrosion((ItemStack)stack, (World)worldIn, (Entity)entityIn, (int)itemSlot, (boolean)isSelected);
    }

    public ProjectileLauncherNBT buildTagData(List<Material> materials) {
        ProjectileLauncherNBT data = new ProjectileLauncherNBT();
        HeadMaterialStats head1 = (HeadMaterialStats)materials.get(0).getStatsOrUnknown("head");
        HeadMaterialStats head2 = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        BowMaterialStats limb1 = (BowMaterialStats)materials.get(0).getStatsOrUnknown("bow");
        BowMaterialStats limb2 = (BowMaterialStats)materials.get(1).getStatsOrUnknown("bow");
        BowStringMaterialStats bowstring = (BowStringMaterialStats)materials.get(2).getStatsOrUnknown("bowstring");
        data.head(new HeadMaterialStats[]{head1, head2});
        data.limb(new BowMaterialStats[]{limb1, limb2});
        data.bowstring(new BowStringMaterialStats[]{bowstring});
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    public ICrosshair getCrosshair(ItemStack itemStack, EntityPlayer player) {
        return Crosshairs.SQUARE;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCrosshairState(ItemStack itemStack, EntityPlayer player) {
        return this.getDrawbackProgress(itemStack, (EntityLivingBase)player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean shift = Util.isShiftKeyDown();
        boolean ctrl = Util.isCtrlKeyDown();
        if (!shift && !ctrl) {
            CorrosionHelper.addCorrosionTooltips((ItemStack)stack, tooltip, (boolean)flagIn.func_194127_a());
            tooltip.add("");
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public int getMinRepairFuelCost(ItemStack stack) {
        return Math.round(stack.func_77958_k() / 120) + 1;
    }

    public int getFullRepairFuelCost(ItemStack stack) {
        return Math.round(stack.func_77958_k() / 75) + 1;
    }

    public int getFullRepairLifeCost(ItemStack arg0) {
        return Math.round(arg0.func_77958_k() / 75) + 1;
    }

    public int getMinRepairLifeCost(ItemStack arg0) {
        return Math.round(arg0.func_77958_k() / 60) + 1;
    }

    public void shootProjectile(@Nonnull ItemStack ammoIn, @Nonnull ItemStack bow, World worldIn, EntityPlayer player, int useTime) {
        float progress = this.getDrawbackProgress(bow, useTime);
        float power = ItemBow.func_185059_b((int)((int)(progress * 20.0f))) * progress * this.baseProjectileSpeed();
        power *= ProjectileLauncherNBT.from((ItemStack)bow).range;
        power = (float)((double)power * Math.pow(CorrosionHelper.getModifier((ItemStack)bow), 2.117904));
        if (!worldIn.field_72995_K) {
            TinkerToolEvent.OnBowShoot event = TinkerToolEvent.OnBowShoot.fireEvent((ItemStack)bow, (ItemStack)ammoIn, (EntityPlayer)player, (int)useTime, (float)this.baseInaccuracy());
            ItemStack ammoStackToShoot = ammoIn.func_77946_l();
            for (int i = 0; i < event.projectileCount; ++i) {
                EntityArrow projectile;
                boolean usedAmmo = false;
                if (i == 0 || event.consumeAmmoPerProjectile) {
                    usedAmmo = this.consumeAmmo(ammoIn, player);
                }
                float inaccuracy = event.getBaseInaccuracy();
                if (i > 0) {
                    inaccuracy += event.bonusInaccuracy;
                }
                if ((projectile = this.getProjectileEntity(ammoStackToShoot, bow, worldIn, player, power, inaccuracy = (float)((double)inaccuracy / Math.pow(CorrosionHelper.getModifier((ItemStack)bow), 2.0)), progress * progress, usedAmmo)) == null || !ProjectileEvent.OnLaunch.fireEvent((Entity)projectile, (ItemStack)bow, (EntityLivingBase)player)) continue;
                if (progress >= 1.0f) {
                    projectile.func_70243_d(true);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    ToolHelper.damageTool((ItemStack)bow, (int)1, (EntityLivingBase)player);
                }
                worldIn.func_72838_d((Entity)projectile);
            }
        }
        this.playShootSound(power, worldIn, player);
    }

    public EntityArrow getProjectileEntity(ItemStack ammo, ItemStack bow, World world, EntityPlayer player, float power, float inaccuracy, float progress, boolean usedAmmo) {
        if (ammo.func_77973_b() instanceof IAmmo) {
            return ((IAmmo)ammo.func_77973_b()).getProjectile(ammo, bow, world, player, power, inaccuracy, progress, usedAmmo);
        }
        if (ammo.func_77973_b() instanceof ItemArrow) {
            EntityArrow projectile = ((ItemArrow)ammo.func_77973_b()).func_185052_a(world, ammo, (EntityLivingBase)player);
            projectile.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, power, inaccuracy);
            if (player.field_71075_bZ.field_75098_d) {
                projectile.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
            } else if (!usedAmmo) {
                projectile.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
            }
            return projectile;
        }
        return null;
    }
}

