/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.tools.tooltypes;

import com.existingeevee.moretcon.other.betweenlands.IBetweenTinkerTool;
import com.existingeevee.moretcon.tools.CrashyBLItems;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import thebetweenlands.api.item.CorrosionHelper;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.api.item.ICorrodible;

public class BetweenPickaxe
extends AoeToolCore
implements ICorrodible,
IAnimatorRepairable,
IBetweenTinkerTool {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150334_T, Blocks.field_150318_D, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au});
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151573_f, (Object)Material.field_151574_g, (Object)Material.field_151576_e, (Object)Material.field_151588_w, (Object)Material.field_151592_s, (Object)Material.field_151598_x, (Object[])new Material[]{Material.field_76233_E});

    public BetweenPickaxe() {
        this(PartMaterialType.handle((IToolPart)TinkerTools.toolRod), PartMaterialType.head((IToolPart)CrashyBLItems.betweenPickHead), PartMaterialType.extra((IToolPart)TinkerTools.binding));
        this.func_77655_b("blpick");
        TinkerRegistry.registerToolCrafting((ToolCore)this);
        CorrosionHelper.addCorrosionPropertyOverrides((Item)this);
    }

    public BetweenPickaxe(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(new Category[]{Category.HARVEST});
        this.setHarvestLevel("pickaxe", 0);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List)subItems, new slimeknights.tconstruct.library.materials.Material[0]);
            this.addInfiTool((List)subItems, "Between-InfiHarvester");
        }
    }

    public boolean isEffective(IBlockState state) {
        return effective_materials.contains((Object)state.func_185904_a()) || EFFECTIVE_ON.contains(state.func_177230_c());
    }

    public float damagePotential() {
        return 1.0f;
    }

    public double attackSpeed() {
        return 1.2f;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        float str = !this.isEffective(state) ? super.func_150893_a(stack, state) : ToolHelper.calcDigSpeed((ItemStack)stack, (IBlockState)state);
        str = CorrosionHelper.getDestroySpeed((float)str, (ItemStack)stack, (IBlockState)state);
        return str;
    }

    protected ToolNBT buildTagData(List<slimeknights.tconstruct.library.materials.Material> materials) {
        return this.buildDefaultTag(materials);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return CorrosionHelper.shouldCauseBlockBreakReset((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return CorrosionHelper.shouldCauseReequipAnimation((ItemStack)oldStack, (ItemStack)newStack, (boolean)slotChanged);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity holder, int slot, boolean isHeldItem) {
        super.func_77663_a(itemStack, world, holder, slot, isHeldItem);
        CorrosionHelper.updateCorrosion((ItemStack)itemStack, (World)world, (Entity)holder, (int)slot, (boolean)isHeldItem);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND && !ToolHelper.isBroken((ItemStack)stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)ToolHelper.getActualAttack((ItemStack)stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)ToolHelper.getActualAttackSpeed((ItemStack)stack) - 4.0, 0));
        }
        TinkerUtil.getTraitsOrdered((ItemStack)stack).forEach(trait -> trait.getAttributeModifiers(slot, stack, multimap));
        return CorrosionHelper.getAttributeModifiers((Multimap)multimap, (EntityEquipmentSlot)slot, (ItemStack)stack, (UUID)field_111210_e, (float)ToolHelper.getActualAttack((ItemStack)stack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean shift = Util.isShiftKeyDown();
        boolean ctrl = Util.isCtrlKeyDown();
        if (!shift && !ctrl) {
            CorrosionHelper.addCorrosionTooltips((ItemStack)stack, tooltip, (boolean)flagIn.func_194127_a());
            tooltip.add("");
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public int getMinRepairFuelCost(ItemStack stack) {
        return Math.round(stack.func_77958_k() / 120) + 1;
    }

    public int getFullRepairFuelCost(ItemStack stack) {
        return Math.round(stack.func_77958_k() / 75) + 1;
    }

    public int getFullRepairLifeCost(ItemStack arg0) {
        return Math.round(arg0.func_77958_k() / 75) + 1;
    }

    public int getMinRepairLifeCost(ItemStack arg0) {
        return Math.round(arg0.func_77958_k() / 60) + 1;
    }
}

