/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.tools.tooltypes;

import com.existingeevee.moretcon.other.betweenlands.IBetweenTinkerTool;
import com.existingeevee.moretcon.tools.CrashyBLItems;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import thebetweenlands.api.item.CorrosionHelper;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.api.item.ICorrodible;

public class BetweenShovel
extends AoeToolCore
implements ICorrodible,
IAnimatorRepairable,
IBetweenTinkerTool {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_192444_dS});
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151577_b, (Object)Material.field_151578_c, (Object)Material.field_151595_p, (Object)Material.field_151596_z, (Object)Material.field_151597_y, (Object)Material.field_151571_B, (Object[])new Material[]{Material.field_151568_F});

    public BetweenShovel() {
        this(PartMaterialType.handle((IToolPart)TinkerTools.toolRod), PartMaterialType.head((IToolPart)CrashyBLItems.betweenShovelHead), PartMaterialType.extra((IToolPart)TinkerTools.binding));
        this.func_77655_b("blshovel");
        TinkerRegistry.registerToolCrafting((ToolCore)this);
        CorrosionHelper.addCorrosionPropertyOverrides((Item)this);
    }

    protected BetweenShovel(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(new Category[]{Category.HARVEST});
        this.setHarvestLevel("shovel", 0);
    }

    public boolean isEffective(IBlockState state) {
        return effective_materials.contains((Object)state.func_185904_a()) || EFFECTIVE_ON.contains(state.func_177230_c());
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block;
        ItemStack stack = player.func_184586_b(hand);
        if (ToolHelper.isBroken((ItemStack)stack)) {
            return EnumActionResult.FAIL;
        }
        EnumActionResult result = Items.field_151047_v.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        if (result == EnumActionResult.SUCCESS) {
            TinkerToolEvent.OnShovelMakePath.fireEvent((ItemStack)stack, (EntityPlayer)player, (World)world, (BlockPos)pos);
        }
        if ((block = world.func_180495_p(pos).func_177230_c()) == Blocks.field_150349_c || block == Blocks.field_185774_da) {
            for (BlockPos aoePos : this.getAOEBlocks(stack, world, player, pos)) {
                if (ToolHelper.isBroken((ItemStack)stack)) break;
                EnumActionResult aoeResult = Items.field_151047_v.func_180614_a(player, world, aoePos, hand, facing, hitX, hitY, hitZ);
                if (result != EnumActionResult.SUCCESS) {
                    result = aoeResult;
                }
                if (aoeResult != EnumActionResult.SUCCESS) continue;
                TinkerToolEvent.OnShovelMakePath.fireEvent((ItemStack)stack, (EntityPlayer)player, (World)world, (BlockPos)aoePos);
            }
        }
        return result;
    }

    public double attackSpeed() {
        return 1.0;
    }

    public float damagePotential() {
        return 0.9f;
    }

    protected ToolNBT buildTagData(List<slimeknights.tconstruct.library.materials.Material> materials) {
        return this.buildDefaultTag(materials);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        float str = !this.isEffective(state) ? super.func_150893_a(stack, state) : ToolHelper.calcDigSpeed((ItemStack)stack, (IBlockState)state);
        str = CorrosionHelper.getDestroySpeed((float)str, (ItemStack)stack, (IBlockState)state);
        return str;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return CorrosionHelper.shouldCauseBlockBreakReset((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return CorrosionHelper.shouldCauseReequipAnimation((ItemStack)oldStack, (ItemStack)newStack, (boolean)slotChanged);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity holder, int slot, boolean isHeldItem) {
        super.func_77663_a(itemStack, world, holder, slot, isHeldItem);
        CorrosionHelper.updateCorrosion((ItemStack)itemStack, (World)world, (Entity)holder, (int)slot, (boolean)isHeldItem);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND && !ToolHelper.isBroken((ItemStack)stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)ToolHelper.getActualAttack((ItemStack)stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)ToolHelper.getActualAttackSpeed((ItemStack)stack) - 4.0, 0));
        }
        TinkerUtil.getTraitsOrdered((ItemStack)stack).forEach(trait -> trait.getAttributeModifiers(slot, stack, multimap));
        return CorrosionHelper.getAttributeModifiers((Multimap)multimap, (EntityEquipmentSlot)slot, (ItemStack)stack, (UUID)field_111210_e, (float)ToolHelper.getActualAttack((ItemStack)stack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean shift = Util.isShiftKeyDown();
        boolean ctrl = Util.isCtrlKeyDown();
        if (!shift && !ctrl) {
            CorrosionHelper.addCorrosionTooltips((ItemStack)stack, tooltip, (boolean)flagIn.func_194127_a());
            tooltip.add("");
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public int getMinRepairFuelCost(ItemStack stack) {
        return Math.round(stack.func_77958_k() / 120) + 1;
    }

    public int getFullRepairFuelCost(ItemStack stack) {
        return Math.round(stack.func_77958_k() / 75) + 1;
    }

    public int getFullRepairLifeCost(ItemStack arg0) {
        return Math.round(arg0.func_77958_k() / 75) + 1;
    }

    public int getMinRepairLifeCost(ItemStack arg0) {
        return Math.round(arg0.func_77958_k() / 60) + 1;
    }
}

