/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.traits;

import com.existingeevee.moretcon.other.Misc;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class Hardcore
extends ModifierTrait {
    public Hardcore() {
        super(Misc.createNonConflictiveName("hardcore"), 0);
    }

    private int multiplier(ItemStack tool) {
        double percent = (double)ToolHelper.getCurrentDurability((ItemStack)tool) / (double)ToolHelper.getMaxDurability((ItemStack)tool);
        if (percent <= 0.2) {
            return 6;
        }
        if (percent <= 0.4) {
            return 4;
        }
        if (percent <= 0.6) {
            return 3;
        }
        if (percent <= 0.8) {
            return 2;
        }
        return 1;
    }

    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        if (ToolHelper.isToolEffective2((ItemStack)tool, (IBlockState)event.getState())) {
            event.setNewSpeed(event.getNewSpeed() * (float)this.multiplier(tool));
        }
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getModifierIdentifier());
        return ImmutableList.of((Object)Util.translateFormatted((String)loc, (Object[])new Object[]{Util.df.format(this.multiplier(tool))}));
    }
}

