/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.world;

import java.util.Random;
import net.minecraft.block.state.IBlockState;

public interface IBlockStateProvider {
    public IBlockState getNextBlock(Random var1);

    public static class AmountBlockStateProvider
    implements IBlockStateProvider {
        IBlockStateProvider rare;
        int raresLeft;
        IBlockStateProvider leftover;

        public AmountBlockStateProvider(IBlockStateProvider rare, IBlockStateProvider leftover, int amount) {
            this.rare = rare;
            this.leftover = leftover;
            this.raresLeft = amount;
        }

        @Override
        public IBlockState getNextBlock(Random rand) {
            if (this.raresLeft > 0) {
                --this.raresLeft;
                return this.rare.getNextBlock(rand);
            }
            return this.leftover.getNextBlock(rand);
        }
    }

    public static class RandomBlockStateProvider
    implements IBlockStateProvider {
        boolean trueIfProviders = false;
        IBlockState[] states;
        IBlockStateProvider[] providers;

        public RandomBlockStateProvider(IBlockState ... states) {
            this.states = states;
        }

        public RandomBlockStateProvider(IBlockStateProvider ... providers) {
            this.providers = providers;
            this.trueIfProviders = true;
        }

        @Override
        public IBlockState getNextBlock(Random rand) {
            if (this.trueIfProviders) {
                return this.providers[rand.nextInt(this.providers.length)].getNextBlock(rand);
            }
            return this.states[rand.nextInt(this.states.length)];
        }
    }

    public static class ConstantBlockStateProvider
    implements IBlockStateProvider {
        IBlockState state;

        public ConstantBlockStateProvider(IBlockState state) {
            this.state = state;
        }

        @Override
        public IBlockState getNextBlock(Random rand) {
            return this.state;
        }
    }
}

