/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.moretcon.world;

import com.existingeevee.moretcon.block.ModBlocks;
import com.existingeevee.moretcon.other.CompatManager;
import com.existingeevee.moretcon.other.ConfigHandler;
import com.existingeevee.moretcon.world.IBlockStateProvider;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGen
implements IWorldGenerator {
    private void runGenerator(IBlockState blockToGen, int blockAmount, int chancesToSpawn, int minHeight, int maxHeight, Predicate<IBlockState> blockToReplace, World world, Random rand, int chunkX, int chunkZ) {
        this.runGenerator(new IBlockStateProvider.ConstantBlockStateProvider(blockToGen), blockAmount, chancesToSpawn, minHeight, maxHeight, blockToReplace, world, rand, chunkX, chunkZ);
    }

    private void runGenerator(final IBlockStateProvider blockToGen, final int blockAmount, int chancesToSpawn, int minHeight, int maxHeight, final Predicate<IBlockState> blockToReplace, World world, Random rand, int chunkX, int chunkZ) {
        if (!ConfigHandler.disableOreGen) {
            if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
                throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
            }
            WorldGenMinable generator = new WorldGenMinable(Blocks.field_150348_b.func_176223_P(), blockAmount, blockToReplace){

                public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
                    float f = rand.nextFloat() * (float)Math.PI;
                    double d0 = (float)(position.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * (float)blockAmount / 8.0f;
                    double d1 = (float)(position.func_177958_n() + 8) - MathHelper.func_76126_a((float)f) * (float)blockAmount / 8.0f;
                    double d2 = (float)(position.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)blockAmount / 8.0f;
                    double d3 = (float)(position.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)blockAmount / 8.0f;
                    double d4 = position.func_177956_o() + rand.nextInt(3) - 2;
                    double d5 = position.func_177956_o() + rand.nextInt(3) - 2;
                    for (int i = 0; i < blockAmount; ++i) {
                        float f1 = (float)i / (float)blockAmount;
                        double d6 = d0 + (d1 - d0) * (double)f1;
                        double d7 = d4 + (d5 - d4) * (double)f1;
                        double d8 = d2 + (d3 - d2) * (double)f1;
                        double d9 = rand.nextDouble() * (double)blockAmount / 16.0;
                        double d10 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
                        double d11 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
                        int j = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
                        int k = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
                        int l = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
                        int i1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
                        int j1 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
                        int k1 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
                        for (int l1 = j; l1 <= i1; ++l1) {
                            double d12 = ((double)l1 + 0.5 - d6) / (d10 / 2.0);
                            if (!(d12 * d12 < 1.0)) continue;
                            for (int i2 = k; i2 <= j1; ++i2) {
                                double d13 = ((double)i2 + 0.5 - d7) / (d11 / 2.0);
                                if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                                for (int j2 = l; j2 <= k1; ++j2) {
                                    BlockPos blockpos;
                                    IBlockState state;
                                    double d14 = ((double)j2 + 0.5 - d8) / (d10 / 2.0);
                                    if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || !(state = worldIn.func_180495_p(blockpos = new BlockPos(l1, i2, j2))).func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos, blockToReplace)) continue;
                                    worldIn.func_180501_a(blockpos, blockToGen.getNextBlock(rand), 2);
                                }
                            }
                        }
                    }
                    return true;
                }
            };
            int heightdiff = maxHeight - minHeight + 1;
            for (int i = 0; i < chancesToSpawn; ++i) {
                int x = chunkX * 16 + rand.nextInt(16);
                int y = minHeight + rand.nextInt(heightdiff);
                int z = chunkZ * 16 + rand.nextInt(16);
                generator.func_180709_b(world, rand, new BlockPos(x, y, z));
            }
        }
    }

    private void runGeneratorAsteroid(final IBlockStateProvider blockToGen, final int blockAmount, int chancesToSpawn, int minHeight, int maxHeight, final Predicate<IBlockState> blockToReplace, World world, Random rand, int chunkX, int chunkZ) {
        if (!ConfigHandler.disableOreGen) {
            if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
                throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
            }
            WorldGenMinable generator = new WorldGenMinable(Blocks.field_150348_b.func_176223_P(), blockAmount, blockToReplace){

                public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
                    float f = rand.nextFloat() * 4.0f;
                    double d0 = (float)(position.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * (float)blockAmount / 8.0f;
                    double d1 = (float)(position.func_177958_n() + 8) - MathHelper.func_76126_a((float)f) * (float)blockAmount / 8.0f;
                    double d2 = (float)(position.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)blockAmount / 8.0f;
                    double d3 = (float)(position.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)blockAmount / 8.0f;
                    double d4 = position.func_177956_o() + rand.nextInt(3) - 2;
                    double d5 = position.func_177956_o() + rand.nextInt(3) - 2;
                    for (int i = 0; i < blockAmount; ++i) {
                        float f1 = (float)i / (float)blockAmount;
                        double d6 = d0 + (d1 - d0) * (double)f1;
                        double d7 = d4 + (d5 - d4) * (double)f1;
                        double d8 = d2 + (d3 - d2) * (double)f1;
                        double d9 = rand.nextDouble() * (double)blockAmount / 16.0;
                        double d10 = (double)(MathHelper.func_76126_a((float)(3.0f * f1 * (float)rand.nextInt(4))) + 1.0f) * d9 + 1.0;
                        double d11 = (double)(MathHelper.func_76126_a((float)(4.0f * f1 * (float)rand.nextInt(4))) + 1.0f) * d9 + 1.0;
                        int j = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
                        int k = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
                        int l = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
                        int i1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
                        int j1 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
                        int k1 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
                        for (int l1 = j; l1 <= i1; ++l1) {
                            double d12 = ((double)l1 + 0.5 - d6) / (d10 / 2.0);
                            if (!(d12 * d12 < 1.0)) continue;
                            for (int i2 = k; i2 <= j1; ++i2) {
                                double d13 = ((double)i2 + 0.5 - d7) / (d11 / 2.0);
                                if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                                for (int j2 = l; j2 <= k1; ++j2) {
                                    BlockPos blockpos;
                                    IBlockState state;
                                    double d14 = ((double)j2 + 0.5 - d8) / (d10 / 2.0);
                                    if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || !(state = worldIn.func_180495_p(blockpos = new BlockPos(l1, i2, j2))).func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos, blockToReplace)) continue;
                                    worldIn.func_180501_a(blockpos, blockToGen.getNextBlock(rand), 2);
                                }
                            }
                        }
                    }
                    return true;
                }
            };
            int heightdiff = maxHeight - minHeight + 1;
            for (int i = 0; i < chancesToSpawn; ++i) {
                int x = chunkX * 16 + rand.nextInt(16);
                int y = minHeight + rand.nextInt(heightdiff);
                int z = chunkZ * 16 + rand.nextInt(16);
                int r = rand.nextInt(4);
                for (int j = 0; j < r; ++j) {
                    generator.func_180709_b(world, rand, new BlockPos(x, y + (rand.nextInt(10) - 5), z));
                }
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (CompatManager.aether_legacy) {
            this.runGenerator(ModBlocks.oreArkenium.func_176223_P(), 8, 3, 5, 250, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)BlocksAether.holystone), world, random, chunkX, chunkZ);
        }
        if (CompatManager.loadMain) {
            this.runGenerator(ModBlocks.oreNaturalVoidSpar.func_176223_P(), 3, 3, 1, 3, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150357_h), world, random, chunkX, chunkZ);
            this.runGenerator(ModBlocks.oreIrradium.func_176223_P(), 4, 3, 12, 32, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), world, random, chunkX, chunkZ);
            this.runGenerator(ModBlocks.oreFusionite.func_176223_P(), 3, 3, 1, 3, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), world, random, chunkX, chunkZ);
            this.runGenerator(ModBlocks.oreGallium.func_176223_P(), 3, 1, 12, 24, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), world, random, chunkX, chunkZ);
            this.runGenerator(ModBlocks.oreVoidSpar.func_176223_P(), 3, 3, 1, 3, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), world, random, chunkX, chunkZ);
            this.runGenerator(ModBlocks.oreEnderal.func_176223_P(), 4, 3, 12, 32, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs), world, random, chunkX, chunkZ);
            this.runGenerator(ModBlocks.oreGarstone.func_176223_P(), 3, 2, 75, 100, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), world, random, chunkX, chunkZ);
            if (WorldGen.peekNextInt(random, 2500) == 0 && world.field_73011_w.func_186058_p().func_186068_a() == DimensionType.THE_END.func_186068_a()) {
                this.runGeneratorAsteroid(new IBlockStateProvider.RandomBlockStateProvider(new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150377_bs.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150377_bs.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150377_bs.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150377_bs.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150377_bs.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150377_bs.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150343_Z.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150343_Z.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150343_Z.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150377_bs.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150377_bs.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150377_bs.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150377_bs.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150377_bs.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150377_bs.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150343_Z.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150343_Z.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(Blocks.field_150343_Z.func_176223_P()), new IBlockStateProvider.AmountBlockStateProvider(new IBlockStateProvider.ConstantBlockStateProvider(ModBlocks.oreGravitoniumDense.func_176223_P()), new IBlockStateProvider.ConstantBlockStateProvider(ModBlocks.oreGravitonium.func_176223_P()), random.nextInt(2) + 1)), random.nextInt(125) + 25, 1, 100, 200, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150350_a), world, random, chunkX, chunkZ);
            }
        }
    }

    private static Random cloneRandom(Random rand) {
        long theSeed = 0L;
        try {
            Field field = Random.class.getDeclaredField("seed");
            field.setAccessible(true);
            theSeed = ((AtomicLong)field.get(rand)).get() ^ 0x5DEECE66DL;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Random(theSeed);
    }

    private static int peekNextInt(Random rand, int bound) {
        return WorldGen.cloneRandom(rand).nextInt(bound);
    }
}

