/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.morebees;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="morebees", name="morebees/MoreBees", category="morebees")
public class ModConfig {
    public static final General general = new General();
    public static final WorldGen worldGen = new WorldGen();
    public static final Bees bees = new Bees();

    @Mod.EventBusSubscriber
    static class ConfigurationHolder {
        ConfigurationHolder() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("morebees")) {
                ConfigManager.load((String)"morebees", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Bees {
        @Config.Comment(value={"The Multipler for the chance of mutation e.g. 0.5 is half as likely 2.0 is twice as likely"})
        @Config.RangeDouble(min=0.0, max=100.0)
        public double mutationMultipler = 2.0;
    }

    public static class WorldGen {
        @Config.Comment(value={"Set to false to disable the generation of rock hives."})
        public boolean genHives = true;
        @Config.Comment(value={"Set to false to disable the generation of ore veins around rock hives."})
        public boolean genHiveFlowers = true;
        @Config.Comment(value={"Sets the worldgen spawn chance for rock hives"})
        @Config.RangeDouble(min=0.0, max=100.0)
        public double rockHiveSpawnRate = 2.0;
        @Config.Comment(value={"A list of Dims to ignore world gen"})
        public int[] rockDimBlackList = new int[0];
    }

    public static class General {
        @Config.Comment(value={"Set to false to disable More Bees frames e.g. mutating frame."})
        public boolean enableFrames = true;
    }
}

