/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.morebees.bees;

import com.tencao.morebees.MBBlocks;
import com.tencao.morebees.MBCore;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBeeFactory;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleRegistry;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.alleles.AlleleEffects;
import forestry.core.genetics.IBranchDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fj\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001e\u00a8\u0006\u001f"}, d2={"Lcom/tencao/morebees/bees/BeeBranches;", "", "Lforestry/core/genetics/IBranchDefinition;", "scientific", "", "(Ljava/lang/String;ILjava/lang/String;)V", "branch", "Lforestry/api/genetics/IClassification;", "defaultTemplate", "", "Lforestry/api/genetics/IAllele;", "getDefaultTemplate", "()[Lforestry/api/genetics/IAllele;", "[Lforestry/api/genetics/IAllele;", "getBranch", "getOrCreateBranch", "uid", "getTemplate", "setBranchProperties", "", "template", "([Lforestry/api/genetics/IAllele;)V", "ROCK", "METAL", "CRYSTAL", "EARTH", "RADIOACTIVE", "APOCALYTIC", "AQUATIC", "WITHER", "SLIME", "morebees"})
public class BeeBranches
extends Enum<BeeBranches>
implements IBranchDefinition {
    public static final /* enum */ BeeBranches ROCK;
    public static final /* enum */ BeeBranches METAL;
    public static final /* enum */ BeeBranches CRYSTAL;
    public static final /* enum */ BeeBranches EARTH;
    public static final /* enum */ BeeBranches RADIOACTIVE;
    public static final /* enum */ BeeBranches APOCALYTIC;
    public static final /* enum */ BeeBranches AQUATIC;
    public static final /* enum */ BeeBranches WITHER;
    public static final /* enum */ BeeBranches SLIME;
    private static final /* synthetic */ BeeBranches[] $VALUES;
    private final IClassification branch;
    private final IAllele[] defaultTemplate;

    static {
        BeeBranches[] beeBranchesArray = new BeeBranches[9];
        BeeBranches[] beeBranchesArray2 = beeBranchesArray;
        beeBranchesArray[0] = ROCK = new ROCK("ROCK", 0);
        beeBranchesArray[1] = METAL = new METAL("METAL", 1);
        beeBranchesArray[2] = CRYSTAL = new CRYSTAL("CRYSTAL", 2);
        beeBranchesArray[3] = EARTH = new EARTH("EARTH", 3);
        beeBranchesArray[4] = RADIOACTIVE = new RADIOACTIVE("RADIOACTIVE", 4);
        beeBranchesArray[5] = APOCALYTIC = new APOCALYTIC("APOCALYTIC", 5);
        beeBranchesArray[6] = AQUATIC = new AQUATIC("AQUATIC", 6);
        beeBranchesArray[7] = WITHER = new WITHER("WITHER", 7);
        beeBranchesArray[8] = SLIME = new SLIME("SLIME", 8);
        $VALUES = beeBranchesArray;
    }

    private final IClassification getOrCreateBranch(String uid, String scientific) {
        IClassification fetchBranch = AlleleManager.alleleRegistry.getClassification("genus.bees." + uid);
        if (fetchBranch == null) {
            IBeeFactory iBeeFactory = BeeManager.beeFactory;
            if (iBeeFactory == null) {
                Intrinsics.throwNpe();
            }
            fetchBranch = iBeeFactory.createBranch(uid, scientific);
            Logger logger = MBCore.INSTANCE.getLOGGER();
            IAlleleRegistry iAlleleRegistry = AlleleManager.alleleRegistry;
            Intrinsics.checkExpressionValueIsNotNull((Object)iAlleleRegistry, (String)"AlleleManager.alleleRegistry");
            logger.info(iAlleleRegistry.getRegisteredClassifications().keySet());
            IClassification parent = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.GENUS, uid, scientific);
            IClassification iClassification = fetchBranch;
            if (iClassification == null) {
                Intrinsics.throwNpe();
            }
            parent.addMemberGroup(iClassification);
        }
        return fetchBranch;
    }

    protected void setBranchProperties(@NotNull IAllele[] template) {
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
    }

    @NotNull
    public IAllele[] getTemplate() {
        IAllele[] template = this.getDefaultTemplate();
        this.setBranchProperties(template);
        return template;
    }

    @NotNull
    public IClassification getBranch() {
        return this.branch;
    }

    private final IAllele[] getDefaultTemplate() {
        IAllele[] iAlleleArray = this.defaultTemplate;
        if (iAlleleArray.length == 0) {
            IAllele[] template = new IAllele[EnumBeeChromosome.values().length];
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TOLERATES_RAIN, false);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWEST);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectNone);
            IAllele[] iAlleleArray2 = Arrays.copyOf(template, template.length);
            Intrinsics.checkExpressionValueIsNotNull((Object)iAlleleArray2, (String)"Arrays.copyOf(template, template.size)");
            return iAlleleArray2;
        }
        IAllele[] iAlleleArray3 = Arrays.copyOf(this.defaultTemplate, this.defaultTemplate.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAlleleArray3, (String)"Arrays.copyOf(field, field.size)");
        return iAlleleArray3;
    }

    protected BeeBranches(String scientific) {
        Intrinsics.checkParameterIsNotNull((Object)scientific, (String)"scientific");
        String string = this.name();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        BeeBranches beeBranches = this;
        BeeBranches beeBranches2 = this;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string4 = string3;
        beeBranches2.branch = beeBranches.getOrCreateBranch(string4, scientific);
        this.defaultTemplate = new IAllele[0];
    }

    public static BeeBranches[] values() {
        return (BeeBranches[])$VALUES.clone();
    }

    public static BeeBranches valueOf(String string) {
        return Enum.valueOf(BeeBranches.class, string);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/tencao/morebees/bees/BeeBranches$ROCK;", "Lcom/tencao/morebees/bees/BeeBranches;", "(Ljava/lang/String;I)V", "setBranchProperties", "", "alleles", "", "Lforestry/api/genetics/IAllele;", "([Lforestry/api/genetics/IAllele;)V", "morebees"})
    public static final class ROCK
    extends BeeBranches {
        @Override
        protected void setBranchProperties(@NotNull IAllele[] alleles) {
            Intrinsics.checkParameterIsNotNull((Object)alleles, (String)"alleles");
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)MBBlocks.INSTANCE.getFlowerTypeOre());
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        }

        /*
         * WARNING - void declaration
         */
        ROCK() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/tencao/morebees/bees/BeeBranches$METAL;", "Lcom/tencao/morebees/bees/BeeBranches;", "(Ljava/lang/String;I)V", "setBranchProperties", "", "alleles", "", "Lforestry/api/genetics/IAllele;", "([Lforestry/api/genetics/IAllele;)V", "morebees"})
    public static final class METAL
    extends BeeBranches {
        @Override
        protected void setBranchProperties(@NotNull IAllele[] alleles) {
            Intrinsics.checkParameterIsNotNull((Object)alleles, (String)"alleles");
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)MBBlocks.INSTANCE.getFlowerTypeOre());
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        }

        /*
         * WARNING - void declaration
         */
        METAL() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/tencao/morebees/bees/BeeBranches$CRYSTAL;", "Lcom/tencao/morebees/bees/BeeBranches;", "(Ljava/lang/String;I)V", "setBranchProperties", "", "alleles", "", "Lforestry/api/genetics/IAllele;", "([Lforestry/api/genetics/IAllele;)V", "morebees"})
    public static final class CRYSTAL
    extends BeeBranches {
        @Override
        protected void setBranchProperties(@NotNull IAllele[] alleles) {
            Intrinsics.checkParameterIsNotNull((Object)alleles, (String)"alleles");
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)MBBlocks.INSTANCE.getFlowerTypeOre());
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
        }

        /*
         * WARNING - void declaration
         */
        CRYSTAL() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/tencao/morebees/bees/BeeBranches$EARTH;", "Lcom/tencao/morebees/bees/BeeBranches;", "(Ljava/lang/String;I)V", "setBranchProperties", "", "alleles", "", "Lforestry/api/genetics/IAllele;", "([Lforestry/api/genetics/IAllele;)V", "morebees"})
    public static final class EARTH
    extends BeeBranches {
        @Override
        protected void setBranchProperties(@NotNull IAllele[] alleles) {
            Intrinsics.checkParameterIsNotNull((Object)alleles, (String)"alleles");
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        }

        /*
         * WARNING - void declaration
         */
        EARTH() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/tencao/morebees/bees/BeeBranches$RADIOACTIVE;", "Lcom/tencao/morebees/bees/BeeBranches;", "(Ljava/lang/String;I)V", "setBranchProperties", "", "alleles", "", "Lforestry/api/genetics/IAllele;", "([Lforestry/api/genetics/IAllele;)V", "morebees"})
    public static final class RADIOACTIVE
    extends BeeBranches {
        @Override
        protected void setBranchProperties(@NotNull IAllele[] alleles) {
            Intrinsics.checkParameterIsNotNull((Object)alleles, (String)"alleles");
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)MBBlocks.INSTANCE.getFlowerTypeUranium());
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)MBBlocks.INSTANCE.getEffectRadiation());
        }

        /*
         * WARNING - void declaration
         */
        RADIOACTIVE() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/tencao/morebees/bees/BeeBranches$APOCALYTIC;", "Lcom/tencao/morebees/bees/BeeBranches;", "(Ljava/lang/String;I)V", "setBranchProperties", "", "alleles", "", "Lforestry/api/genetics/IAllele;", "([Lforestry/api/genetics/IAllele;)V", "morebees"})
    public static final class APOCALYTIC
    extends BeeBranches {
        @Override
        protected void setBranchProperties(@NotNull IAllele[] alleles) {
            Intrinsics.checkParameterIsNotNull((Object)alleles, (String)"alleles");
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)MBBlocks.INSTANCE.getFlowerTypeTNT());
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_4);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectCreeper);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectIgnition);
        }

        /*
         * WARNING - void declaration
         */
        APOCALYTIC() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/tencao/morebees/bees/BeeBranches$AQUATIC;", "Lcom/tencao/morebees/bees/BeeBranches;", "(Ljava/lang/String;I)V", "setBranchProperties", "", "alleles", "", "Lforestry/api/genetics/IAllele;", "([Lforestry/api/genetics/IAllele;)V", "morebees"})
    public static final class AQUATIC
    extends BeeBranches {
        @Override
        protected void setBranchProperties(@NotNull IAllele[] alleles) {
            Intrinsics.checkParameterIsNotNull((Object)alleles, (String)"alleles");
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)MBBlocks.INSTANCE.getFlowerTypeWater());
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_3);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
        }

        /*
         * WARNING - void declaration
         */
        AQUATIC() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/tencao/morebees/bees/BeeBranches$WITHER;", "Lcom/tencao/morebees/bees/BeeBranches;", "(Ljava/lang/String;I)V", "setBranchProperties", "", "alleles", "", "Lforestry/api/genetics/IAllele;", "([Lforestry/api/genetics/IAllele;)V", "morebees"})
    public static final class WITHER
    extends BeeBranches {
        @Override
        protected void setBranchProperties(@NotNull IAllele[] alleles) {
            Intrinsics.checkParameterIsNotNull((Object)alleles, (String)"alleles");
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGEST);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_3);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_5);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)MBBlocks.INSTANCE.getEffectWither());
        }

        /*
         * WARNING - void declaration
         */
        WITHER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/tencao/morebees/bees/BeeBranches$SLIME;", "Lcom/tencao/morebees/bees/BeeBranches;", "(Ljava/lang/String;I)V", "setBranchProperties", "", "alleles", "", "Lforestry/api/genetics/IAllele;", "([Lforestry/api/genetics/IAllele;)V", "morebees"})
    public static final class SLIME
    extends BeeBranches {
        @Override
        protected void setBranchProperties(@NotNull IAllele[] alleles) {
            Intrinsics.checkParameterIsNotNull((Object)alleles, (String)"alleles");
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)MBBlocks.INSTANCE.getFlowerTypeSlime());
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)MBBlocks.INSTANCE.getEffectSlimy());
        }

        /*
         * WARNING - void declaration
         */
        SLIME() {
            void var1_1;
        }
    }
}

