/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.morebees.blocks;

import com.tencao.morebees.MBCore;
import com.tencao.morebees.hives.HiveTypes;
import com.tencao.morebees.items.ItemModelProvider;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.apiculture.IHiveTile;
import forestry.api.core.Tabs;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.tiles.TileHive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u001f\u001a\u00020 2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J0\u0010#\u001a\u00020 2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0016\u00a8\u0006("}, d2={"Lcom/tencao/morebees/blocks/BlockHive;", "Lnet/minecraft/block/BlockContainer;", "Lcom/tencao/morebees/items/ItemModelProvider;", "name", "", "(Ljava/lang/String;)V", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "createNewTileEntity", "Lnet/minecraft/tileentity/TileEntity;", "worldIn", "Lnet/minecraft/world/World;", "meta", "", "getDrops", "", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "fortune", "getMetaFromState", "getRenderType", "Lnet/minecraft/util/EnumBlockRenderType;", "getStateForType", "type", "Lcom/tencao/morebees/hives/HiveTypes;", "getStateFromMeta", "onBlockClicked", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "onBlockHarvested", "registerItemModel", "item", "Lnet/minecraft/item/Item;", "Companion", "morebees"})
public final class BlockHive
extends BlockContainer
implements ItemModelProvider {
    @NotNull
    private static final PropertyEnum<HiveTypes> HIVE_TYPES;
    private static String name;
    public static final Companion Companion;

    @Nullable
    public TileEntity func_149915_a(@NotNull World worldIn, int meta) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        return (TileEntity)new TileHive();
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{(IProperty)HIVE_TYPES});
    }

    public int func_176201_c(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return ((HiveTypes)((Object)state.func_177229_b((IProperty)HIVE_TYPES))).getMeta();
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        IBlockState iBlockState = this.func_176223_P().func_177226_a((IProperty)HIVE_TYPES, (Comparable)((Object)HiveTypes.values()[meta]));
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"defaultState.withPropert\u2026HiveTypes.values()[meta])");
        return iBlockState;
    }

    @NotNull
    public final IBlockState getStateForType(@NotNull HiveTypes type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        IBlockState iBlockState = this.func_176223_P().func_177226_a((IProperty)HIVE_TYPES, (Comparable)((Object)type));
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"defaultState.withPropert\u2026eTypes>(HIVE_TYPES, type)");
        return iBlockState;
    }

    public void func_180649_a(@Nullable World world, @Nullable BlockPos pos, @Nullable EntityPlayer player) {
        TileEntity tile;
        super.func_180649_a(world, pos, player);
        World world2 = world;
        if (world2 == null) {
            Intrinsics.throwNpe();
        }
        BlockPos blockPos = pos;
        if (blockPos == null) {
            Intrinsics.throwNpe();
        }
        if ((tile = world2.func_175625_s(blockPos)) instanceof IHiveTile) {
            IHiveTile hive = (IHiveTile)tile;
            EntityPlayer entityPlayer = player;
            if (entityPlayer == null) {
                Intrinsics.throwNpe();
            }
            hive.onAttack(world, pos, entityPlayer);
        }
    }

    public void func_176208_a(@Nullable World world, @Nullable BlockPos pos, @Nullable IBlockState state, @Nullable EntityPlayer player) {
        World world2 = world;
        if (world2 == null) {
            Intrinsics.throwNpe();
        }
        IBlockAccess iBlockAccess = (IBlockAccess)world2;
        BlockPos blockPos = pos;
        if (blockPos == null) {
            Intrinsics.throwNpe();
        }
        EntityPlayer entityPlayer = player;
        if (entityPlayer == null) {
            Intrinsics.throwNpe();
        }
        boolean canHarvest = this.canHarvestBlock(iBlockAccess, blockPos, entityPlayer);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IHiveTile) {
            IHiveTile hive = (IHiveTile)tile;
            hive.onBroken(world, pos, player, canHarvest);
        }
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull IBlockState state, int fortune) {
        IBee bee;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Random random = world instanceof World ? ((World)world).field_73012_v : BlockHive.access$getRANDOM$p$s64279661();
        List hiveDrops = CollectionsKt.shuffled((Iterable)BlockHive.Companion.getDropsForHive(this.func_176201_c(state)));
        int tries = 0;
        boolean hasPrincess = false;
        block0: while (tries <= 10 && !hasPrincess) {
            ++tries;
            for (IHiveDrop drop : hiveDrops) {
                if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
                bee = drop.getBeeType(world, pos);
                if ((double)random.nextFloat() < drop.getIgnobleChance(world, pos, fortune)) {
                    bee.setIsNatural(false);
                }
                IBeeRoot iBeeRoot = BeeManager.beeRoot;
                if (iBeeRoot == null) {
                    Intrinsics.throwNpe();
                }
                ItemStack princess = iBeeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.PRINCESS);
                drops.add(princess);
                hasPrincess = true;
                continue block0;
            }
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
            bee = drop.getBeeType(world, pos);
            IBeeRoot iBeeRoot = BeeManager.beeRoot;
            if (iBeeRoot == null) {
                Intrinsics.throwNpe();
            }
            ItemStack drone = iBeeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.DRONE);
            drops.add(drone);
            break;
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
            drops.addAll((Collection)drop.getExtraItems(world, pos, fortune));
            break;
        }
        return drops;
    }

    @NotNull
    public EnumBlockRenderType func_149645_b(@Nullable IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void registerItemModel(@NotNull Item item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        MBCore.INSTANCE.getProxy$morebees().registerItemRenderer(item, 0, name);
    }

    public BlockHive(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(Material.field_151575_d);
        BlockHive.name = name;
        this.func_149715_a(0.4f);
        this.func_149711_c(2.5f);
        this.func_149647_a(Tabs.tabApiculture);
        this.setHarvestLevel("scoop", 0);
        BlockStateContainer blockStateContainer = this.field_176227_L;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockStateContainer, (String)"this.blockState");
        this.func_180632_j(blockStateContainer.func_177621_b().func_177226_a((IProperty)HIVE_TYPES, (Comparable)((Object)HiveTypes.ROCK)));
        this.func_149663_c(name);
        this.setRegistryName(name);
    }

    static {
        Companion = new Companion(null);
        PropertyEnum propertyEnum = PropertyEnum.func_177709_a((String)"hive", HiveTypes.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyEnum, (String)"PropertyEnum.create<Hive\u2026\", HiveTypes::class.java)");
        HIVE_TYPES = propertyEnum;
        name = "";
    }

    public static final /* synthetic */ Random access$getRANDOM$p$s64279661() {
        return Block.RANDOM;
    }

    public static final /* synthetic */ void access$setRANDOM$p$s64279661(Random random) {
        Block.RANDOM = random;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/tencao/morebees/blocks/BlockHive$Companion;", "", "()V", "HIVE_TYPES", "Lnet/minecraft/block/properties/PropertyEnum;", "Lcom/tencao/morebees/hives/HiveTypes;", "getHIVE_TYPES", "()Lnet/minecraft/block/properties/PropertyEnum;", "name", "", "getDropsForHive", "", "Lforestry/api/apiculture/IHiveDrop;", "meta", "", "getHiveNameForMeta", "morebees"})
    public static final class Companion {
        @NotNull
        public final PropertyEnum<HiveTypes> getHIVE_TYPES() {
            return HIVE_TYPES;
        }

        private final List<IHiveDrop> getDropsForHive(int meta) {
            List list;
            String hiveName = this.getHiveNameForMeta(meta);
            CharSequence charSequence = hiveName;
            if (charSequence.length() == 0) {
                list = CollectionsKt.emptyList();
            } else {
                List list2 = ModuleApiculture.getHiveRegistry().getDrops(hiveName);
                list = list2;
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ModuleApiculture.getHive\u2026stry().getDrops(hiveName)");
            }
            return list;
        }

        private final String getHiveNameForMeta(int meta) {
            return HiveTypes.values()[meta].getHiveUid();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

