/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.morebees.hives;

import com.tencao.morebees.MBBlocks;
import com.tencao.morebees.ModConfig;
import com.tencao.morebees.bees.BeeSpecies;
import com.tencao.morebees.hives.HiveGen;
import com.tencao.morebees.hives.HiveTypes;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B'\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b%\u00a8\u0006&"}, d2={"Lcom/tencao/morebees/hives/HiveDescription;", "", "Lforestry/api/apiculture/hives/IHiveDescription;", "hiveType", "Lcom/tencao/morebees/hives/HiveTypes;", "genChance", "", "beeTemplate", "Lcom/tencao/morebees/bees/BeeSpecies;", "hiveGen", "Lforestry/api/apiculture/hives/IHiveGen;", "(Ljava/lang/String;ILcom/tencao/morebees/hives/HiveTypes;FLcom/tencao/morebees/bees/BeeSpecies;Lforestry/api/apiculture/hives/IHiveGen;)V", "beeGenome", "Lforestry/api/apiculture/IBeeGenome;", "blockState", "Lnet/minecraft/block/state/IBlockState;", "getBlockState", "getGenChance", "getHiveGen", "isGoodBiome", "", "biome", "Lnet/minecraft/world/biome/Biome;", "isGoodHumidity", "humidity", "Lforestry/api/core/EnumHumidity;", "isGoodTemperature", "temperature", "Lforestry/api/core/EnumTemperature;", "postGen", "", "world", "Lnet/minecraft/world/World;", "rand", "Ljava/util/Random;", "pos", "Lnet/minecraft/util/math/BlockPos;", "ROCK", "morebees"})
public class HiveDescription
extends Enum<HiveDescription>
implements IHiveDescription {
    public static final /* enum */ HiveDescription ROCK;
    private static final /* synthetic */ HiveDescription[] $VALUES;
    private final IBlockState blockState;
    private final IBeeGenome beeGenome;
    private final float genChance;
    private final IHiveGen hiveGen;

    static {
        HiveDescription[] hiveDescriptionArray = new HiveDescription[1];
        HiveDescription[] hiveDescriptionArray2 = hiveDescriptionArray;
        hiveDescriptionArray[0] = ROCK = new ROCK("ROCK", 0);
        $VALUES = hiveDescriptionArray;
    }

    @NotNull
    public IHiveGen getHiveGen() {
        return this.hiveGen;
    }

    @NotNull
    public IBlockState getBlockState() {
        return this.blockState;
    }

    public boolean isGoodBiome(@NotNull Biome biome) {
        Intrinsics.checkParameterIsNotNull((Object)biome, (String)"biome");
        return !BiomeHelper.isBiomeHellish((Biome)biome);
    }

    public boolean isGoodHumidity(@NotNull EnumHumidity humidity) {
        Intrinsics.checkParameterIsNotNull((Object)humidity, (String)"humidity");
        IAlleleBeeSpecies iAlleleBeeSpecies = this.beeGenome.getPrimary();
        Intrinsics.checkExpressionValueIsNotNull((Object)iAlleleBeeSpecies, (String)"beeGenome.primary");
        EnumHumidity idealHumidity = iAlleleBeeSpecies.getHumidity();
        EnumTolerance humidityTolerance = this.beeGenome.getToleranceHumid();
        return AlleleManager.climateHelper.isWithinLimits(humidity, idealHumidity, humidityTolerance);
    }

    public boolean isGoodTemperature(@NotNull EnumTemperature temperature) {
        Intrinsics.checkParameterIsNotNull((Object)temperature, (String)"temperature");
        IAlleleBeeSpecies iAlleleBeeSpecies = this.beeGenome.getPrimary();
        Intrinsics.checkExpressionValueIsNotNull((Object)iAlleleBeeSpecies, (String)"beeGenome.primary");
        EnumTemperature idealTemperature = iAlleleBeeSpecies.getTemperature();
        EnumTolerance temperatureTolerance = this.beeGenome.getToleranceTemp();
        return AlleleManager.climateHelper.isWithinLimits(temperature, idealTemperature, temperatureTolerance);
    }

    public float getGenChance() {
        return this.genChance;
    }

    public void postGen(@NotNull World world, @NotNull Random rand, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
    }

    protected HiveDescription(@NotNull HiveTypes hiveType, @NotNull float genChance, BeeSpecies beeTemplate, IHiveGen hiveGen) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)hiveType), (String)"hiveType");
        Intrinsics.checkParameterIsNotNull((Object)((Object)beeTemplate), (String)"beeTemplate");
        Intrinsics.checkParameterIsNotNull((Object)hiveGen, (String)"hiveGen");
        this.genChance = genChance;
        this.hiveGen = hiveGen;
        this.blockState = MBBlocks.INSTANCE.getHive().getStateForType(hiveType);
        this.beeGenome = beeTemplate.getGenome();
    }

    public static HiveDescription[] values() {
        return (HiveDescription[])$VALUES.clone();
    }

    public static HiveDescription valueOf(String string) {
        return Enum.valueOf(HiveDescription.class, string);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/tencao/morebees/hives/HiveDescription$ROCK;", "Lcom/tencao/morebees/hives/HiveDescription;", "(Ljava/lang/String;I)V", "getHiveGen", "Lforestry/api/apiculture/hives/IHiveGen;", "isGoodBiome", "", "biome", "Lnet/minecraft/world/biome/Biome;", "morebees"})
    public static final class ROCK
    extends HiveDescription {
        @Override
        public boolean isGoodBiome(@NotNull Biome biome) {
            Intrinsics.checkParameterIsNotNull((Object)biome, (String)"biome");
            return !BiomeHelper.isBiomeHellish((Biome)biome) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END);
        }

        @Override
        @NotNull
        public IHiveGen getHiveGen() {
            return HiveGen.ROCK;
        }

        /*
         * WARNING - void declaration
         */
        ROCK() {
            void var1_1;
            float f = (float)ModConfig.worldGen.rockHiveSpawnRate;
            IHiveGen iHiveGen = HiveManager.genHelper.ground(new Block[]{Blocks.field_150348_b});
            Intrinsics.checkExpressionValueIsNotNull((Object)iHiveGen, (String)"HiveManager.genHelper.ground(Blocks.STONE)");
        }
    }
}

