/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.morebees.hives;

import com.tencao.morebees.ModConfig;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.core.utils.BlockUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u001fB#\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J \u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u001e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u001e\u00a8\u0006 "}, d2={"Lcom/tencao/morebees/hives/HiveGen;", "", "Lforestry/api/apiculture/hives/IHiveGen;", "type", "Lcom/tencao/morebees/hives/HiveGen$GenType;", "groundBlocks", "", "Lnet/minecraft/block/Block;", "(Ljava/lang/String;ILcom/tencao/morebees/hives/HiveGen$GenType;[Lnet/minecraft/block/Block;)V", "groundMaterials", "Ljava/util/HashSet;", "Lnet/minecraft/block/material/Material;", "canReplace", "", "blockState", "Lnet/minecraft/block/state/IBlockState;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "checkGroundLocation", "checkTreeLocation", "checkValidLocation", "getGroundGen", "x", "", "z", "getPosForHive", "getTreeGen", "isTreeBlock", "ROCK", "GenType", "morebees"})
public abstract class HiveGen
extends Enum<HiveGen>
implements IHiveGen {
    public static final /* enum */ HiveGen ROCK;
    private static final /* synthetic */ HiveGen[] $VALUES;
    private final HashSet<Material> groundMaterials;
    private final GenType type;

    static {
        HiveGen[] hiveGenArray = new HiveGen[1];
        HiveGen[] hiveGenArray2 = hiveGenArray;
        hiveGenArray[0] = ROCK = new ROCK("ROCK", 0);
        $VALUES = hiveGenArray;
    }

    public boolean canReplace(@NotNull IBlockState blockState, @NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)blockState, (String)"blockState");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return BlockUtil.canReplace((IBlockState)blockState, (World)world, (BlockPos)pos);
    }

    public final boolean checkValidLocation(@NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return this.type == GenType.TREE ? this.checkTreeLocation(world, pos) : this.checkGroundLocation(world, pos);
    }

    public final boolean checkGroundLocation(@NotNull World world, @NotNull BlockPos pos) {
        IBlockState groundBlockState;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        IBlockState iBlockState = groundBlockState = world.func_180495_p(pos.func_177977_b());
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"groundBlockState");
        Material groundBlockMaterial = iBlockState.func_185904_a();
        return this.groundMaterials.contains(groundBlockMaterial);
    }

    public final boolean checkTreeLocation(@NotNull World world, @NotNull BlockPos pos) {
        IBlockState blockStateBelow;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        BlockPos posAbove = pos.func_177984_a();
        IBlockState blockStateAbove = world.func_180495_p(posAbove);
        if (!forestry.apiculture.worldgen.HiveGen.isTreeBlock((IBlockState)blockStateAbove, (World)world, (BlockPos)posAbove)) {
            return false;
        }
        BlockPos posBelow = pos.func_177977_b();
        IBlockState iBlockState = blockStateBelow = world.func_180495_p(posBelow);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockStateBelow");
        BlockPos blockPos = posBelow;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"posBelow");
        return this.canReplace(iBlockState, world, blockPos);
    }

    @Nullable
    public BlockPos getPosForHive(@NotNull World world, int x, int z) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        if (this.type == GenType.GROUND) {
            return this.getGroundGen(world, x, z);
        }
        if (this.type == GenType.TREE) {
            return this.getTreeGen(world, x, z);
        }
        return null;
    }

    @Nullable
    public final BlockPos getGroundGen(@NotNull World world, int x, int z) {
        BlockPos topPos;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        BlockPos blockPos = topPos = world.func_175645_m(new BlockPos(x, 0, z));
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"topPos");
        if (blockPos.func_177956_o() == 0) {
            return null;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(topPos);
        IBlockState blockState = world.func_180495_p((BlockPos)pos);
        while (true) {
            if (!forestry.apiculture.worldgen.HiveGen.isTreeBlock((IBlockState)blockState, (World)world, (BlockPos)((BlockPos)pos))) {
                IBlockState iBlockState = blockState;
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockState");
                if (!this.canReplace(iBlockState, world, (BlockPos)pos)) break;
            }
            pos.func_189536_c(EnumFacing.DOWN);
            if (pos.func_177956_o() <= 0) {
                return null;
            }
            blockState = world.func_180495_p((BlockPos)pos);
        }
        return pos.func_177984_a();
    }

    @Nullable
    public final BlockPos getTreeGen(@NotNull World world, int x, int z) {
        IBlockState blockState;
        BlockPos topPos;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        BlockPos blockPos = topPos = world.func_175645_m(new BlockPos(x, 0, z)).func_177977_b();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"topPos");
        if (blockPos.func_177956_o() <= 0) {
            return null;
        }
        IBlockState iBlockState = blockState = world.func_180495_p(topPos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"blockState");
        if (!this.isTreeBlock(iBlockState, world, topPos)) {
            return null;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(topPos);
        do {
            pos.func_189536_c(EnumFacing.DOWN);
        } while (forestry.apiculture.worldgen.HiveGen.isTreeBlock((IBlockState)(blockState = world.func_180495_p((BlockPos)pos)), (World)world, (BlockPos)((BlockPos)pos)));
        return pos.func_185334_h();
    }

    public final boolean isTreeBlock(@NotNull IBlockState blockState, @NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)blockState, (String)"blockState");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Block block = blockState.func_177230_c();
        return block.isLeaves(blockState, (IBlockAccess)world, pos) || block.isWood((IBlockAccess)world, pos);
    }

    /*
     * WARNING - void declaration
     */
    protected HiveGen(GenType type, Block ... groundBlocks) {
        IBlockState iBlockState;
        Collection collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)groundBlocks, (String)"groundBlocks");
        this.type = type;
        this.groundMaterials = new HashSet();
        Block[] blockArray = groundBlocks;
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
        int n = ((void)$receiver$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_13 = item$iv$iv = $receiver$iv$iv[i];
            collection = destination$iv$iv;
            iBlockState = it.func_176223_P();
            collection.add(iBlockState);
        }
        $receiver$iv = (List)destination$iv$iv;
        Collection destination$iv = this.groundMaterials;
        for (Object item$iv : $receiver$iv) {
            void it;
            IBlockState iBlockState2 = (IBlockState)item$iv;
            collection = destination$iv;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
            Intrinsics.checkExpressionValueIsNotNull((Object)v0.func_185904_a(), (String)"it.material");
            collection.add(iBlockState);
        }
    }

    public static HiveGen[] values() {
        return (HiveGen[])$VALUES.clone();
    }

    public static HiveGen valueOf(String string) {
        return Enum.valueOf(HiveGen.class, string);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/tencao/morebees/hives/HiveGen$ROCK;", "Lcom/tencao/morebees/hives/HiveGen;", "(Ljava/lang/String;I)V", "isValidLocation", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "morebees"})
    public static final class ROCK
    extends HiveGen {
        public boolean isValidLocation(@NotNull World world, @NotNull BlockPos pos) {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkExpressionValueIsNotNull((Object)ModConfig.worldGen.rockDimBlackList, (String)"ModConfig.worldGen.rockDimBlackList");
            WorldProvider worldProvider = world.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
            return !ArraysKt.contains((int[])ModConfig.worldGen.rockDimBlackList, (int)worldProvider.getDimension()) ? this.checkValidLocation(world, pos) : false;
        }

        /*
         * WARNING - void declaration
         */
        ROCK() {
            void var1_1;
            Block[] blockArray = new Block[1];
            Block block = Blocks.field_150348_b;
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"Blocks.STONE");
            blockArray[0] = block;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/tencao/morebees/hives/HiveGen$GenType;", "", "(Ljava/lang/String;I)V", "GROUND", "TREE", "morebees"})
    public static final class GenType
    extends Enum<GenType> {
        public static final /* enum */ GenType GROUND;
        public static final /* enum */ GenType TREE;
        private static final /* synthetic */ GenType[] $VALUES;

        static {
            GenType[] genTypeArray = new GenType[2];
            GenType[] genTypeArray2 = genTypeArray;
            genTypeArray[0] = GROUND = new GenType();
            genTypeArray[1] = TREE = new GenType();
            $VALUES = genTypeArray;
        }

        public static GenType[] values() {
            return (GenType[])$VALUES.clone();
        }

        public static GenType valueOf(String string) {
            return Enum.valueOf(GenType.class, string);
        }
    }
}

