/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm;

import dev.necauqua.mods.cm.Log;
import dev.necauqua.mods.cm.SidedHandler;
import dev.necauqua.mods.cm.SizeofCommand;
import dev.necauqua.mods.cm.item.ItemMod;
import dev.necauqua.mods.cm.item.ItemRecalibrator;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="chiseled_me", version="1.12-3.0.0.0-git-e5ce416", acceptedMinecraftVersions="[1.12,1.12.2]", updateJSON="https://raw.githubusercontent.com/wiki/necauqua/chiseled-me/updates.json", certificateFingerprint="c677c954974252994736eb15e855e1e6fc5a2e62", useMetadata=true)
@Mod.EventBusSubscriber(modid="chiseled_me")
public final class ChiseledMe {
    public static final String MODID = "chiseled_me";
    public static final double LOWER_LIMIT = 2.44140625E-4;
    public static final double UPPER_LIMIT = 16.0;
    public static final String ENTITY_SIZE_RULE = "chiseled_me:defaultEntitySize";
    public static final String PLAYER_SIZE_RULE = "chiseled_me:defaultPlayerSize";
    public static final String KEEP_SIZE_RULE = "chiseled_me:keepSize";
    public static final CreativeTabs TAB = new CreativeTabs("chiseled_me"){

        @Nonnull
        public ItemStack func_78016_d() {
            return RECALIBRATOR.create(ItemRecalibrator.RecalibrationType.REDUCTION, (byte)1);
        }
    };
    public static final ItemRecalibrator RECALIBRATOR = new ItemRecalibrator();
    public static final ItemMod BLUE_STAR = new ItemMod("blue_star").setGlowing();
    private static final Item[] ITEMS = new Item[]{RECALIBRATOR, BLUE_STAR, new ItemMod("pym_container"), new ItemMod("pym_container_x").func_77625_d(16), new ItemMod("pym_essence").func_77625_d(42), new ItemMod("pym_essence_x").func_77625_d(13), new ItemMod("pym_essence_b").func_77625_d(7)};

    @Mod.EventHandler
    public void on(FMLPreInitializationEvent e) {
        try {
            for (ASMDataTable.ASMData asmData : e.getAsmData().getAll(Init.class.getName())) {
                String objectName = asmData.getObjectName();
                String name = objectName.substring(0, objectName.indexOf(40));
                Method method = Class.forName(asmData.getClassName()).getDeclaredMethod(name, new Class[0]);
                Log.debug("Found init method " + method);
                method.setAccessible(true);
                method.invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e1) {
            throw new AssertionError("This should not happen", e1);
        }
        catch (InvocationTargetException e1) {
            ChiseledMe.rethrow(e1.getCause());
        }
    }

    @Mod.EventHandler
    public void on(FMLInitializationEvent e) {
        try {
            Class.forName("micdoodle8.mods.galacticraft.core.GalacticraftCore").getField("isHeightConflictingModInstalled").set(null, true);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void on(FMLFingerprintViolationEvent e) {
        Log.warn("FINGERPRINT VIOLATED: you're running some unauthorized modification of the mod, be warned. No support will be provided for any issues encountered while using this jar.");
    }

    @SubscribeEvent
    public static void on(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])ITEMS);
        OreDictionary.registerOre((String)"netherStar", (Item)BLUE_STAR);
    }

    @SubscribeEvent
    public static void on(ModelRegistryEvent e) {
        Arrays.stream(ITEMS).forEach(SidedHandler.instance::registerDefaultModel);
    }

    @Mod.EventHandler
    public void on(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new SizeofCommand());
        GameRules gameRules = e.getServer().func_71218_a(0).func_82736_K();
        gameRules.func_180262_a(ENTITY_SIZE_RULE, "1", GameRules.ValueType.ANY_VALUE);
        gameRules.func_180262_a(PLAYER_SIZE_RULE, "1", GameRules.ValueType.ANY_VALUE);
        gameRules.func_180262_a(KEEP_SIZE_RULE, "false", GameRules.ValueType.BOOLEAN_VALUE);
    }

    public static ResourceLocation ns(String id) {
        return new ResourceLocation(MODID, id);
    }

    private static <E extends Throwable> void rethrow(Throwable exception) throws E {
        throw exception;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Init {
    }
}

