/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm;

import dev.necauqua.mods.cm.item.ItemRecalibrator;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SidedHandler {
    @SidedProxy(modId="chiseled_me")
    public static SidedHandler instance;

    public void registerDefaultModel(Item item) {
    }

    @Nullable
    public World getClientWorld() {
        return null;
    }

    @Nullable
    public EntityPlayer getClientPlayer() {
        return null;
    }

    public String getLocalization(String key, Object ... format) {
        return "";
    }

    public void scheduleClientMainLoopTask(Runnable task) {
    }

    @SideOnly(value=Side.SERVER)
    public static final class ServerProxy
    extends SidedHandler {
    }

    @SideOnly(value=Side.CLIENT)
    public static final class ClientProxy
    extends SidedHandler {
        private static final Minecraft mc = Minecraft.func_71410_x();

        @Override
        public void registerDefaultModel(Item item) {
            ResourceLocation registryName = Objects.requireNonNull(item.getRegistryName());
            ModelResourceLocation mrl = new ModelResourceLocation(registryName, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)mrl);
            if (item instanceof ItemRecalibrator) {
                for (int i = 1; i <= 16; ++i) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)mrl);
                }
            }
        }

        @Override
        public String getLocalization(String key, Object ... parameters) {
            return I18n.func_135052_a((String)key, (Object[])parameters);
        }

        @Override
        @Nullable
        public EntityPlayer getClientPlayer() {
            return ClientProxy.mc.field_71439_g;
        }

        @Override
        @Nullable
        public World getClientWorld() {
            return ClientProxy.mc.field_71441_e;
        }

        @Override
        public void scheduleClientMainLoopTask(Runnable task) {
            mc.func_152344_a(task);
        }
    }
}

