/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm;

import dev.necauqua.mods.cm.Config;
import dev.necauqua.mods.cm.api.IRenderSized;
import dev.necauqua.mods.cm.size.ChangingSizeProcess;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public final class SizeofCommand
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "sizeof";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "commands.chiseled_me:sizeof.usage";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length == 2 || args.length < 1 || args.length > 5) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        Entity entity = SizeofCommand.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        if (args.length == 1) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.chiseled_me:sizeof.get", new Object[]{entity.func_145748_c_(), ((IRenderSized)entity).getSizeCM()}));
            return;
        }
        double size = ((IRenderSized)entity).getSizeCM();
        double arg = SizeofCommand.func_175765_c((String)args[2]);
        switch (args[1]) {
            case "set": {
                size = arg;
                break;
            }
            case "add": {
                size += arg;
                break;
            }
            case "subtract": {
                size -= arg;
                break;
            }
            case "multiply": {
                size *= arg;
                break;
            }
            case "divide": {
                size /= arg;
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
        if (!Config.allowAnySizes) {
            if (size < 2.44140625E-4) {
                throw new NumberInvalidException("commands.generic.num.tooSmall", new Object[]{String.format("%.2f", size), 2.44140625E-4});
            }
            if (size > 16.0) {
                throw new NumberInvalidException("commands.generic.num.tooBig", new Object[]{String.format("%.2f", size), 16.0});
            }
        }
        int lerpTime = 0;
        if (args.length > 3 && !args[3].equals("animate")) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args.length == 4) {
            lerpTime = ChangingSizeProcess.log2LerpTime(((IRenderSized)entity).getSizeCM(), size);
        } else if (args.length == 5) {
            lerpTime = SizeofCommand.func_180528_a((String)args[4], (int)0);
        }
        ((IRenderSized)entity).setSizeCM(size, lerpTime);
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.chiseled_me:sizeof.set", new Object[]{entity.func_145748_c_(), size}));
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        String[] completions;
        switch (args.length) {
            case 1: {
                completions = server.func_71213_z();
                break;
            }
            case 2: {
                completions = new String[]{"set", "add", "subtract", "multiply", "divide"};
                break;
            }
            case 4: {
                completions = new String[]{"animate"};
                break;
            }
            default: {
                completions = new String[]{};
            }
        }
        return SizeofCommand.func_71530_a((String[])args, (String[])completions);
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }
}

