/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.item;

import dev.necauqua.mods.cm.ChiseledMe;
import dev.necauqua.mods.cm.Config;
import dev.necauqua.mods.cm.SidedHandler;
import dev.necauqua.mods.cm.advancements.AdvancementTriggers;
import dev.necauqua.mods.cm.advancements.SizeTrigger;
import dev.necauqua.mods.cm.api.IRenderSized;
import dev.necauqua.mods.cm.item.ItemMod;
import dev.necauqua.mods.cm.size.ChangingSizeProcess;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public final class ItemRecalibrator
extends ItemMod {
    private static boolean entityItemBBoxOffset = true;

    public ItemRecalibrator() {
        super("recalibrator");
        this.func_77625_d(1);
        entityItemBBoxOffset = !Loader.isModLoaded((String)"itemphysic");
        this.func_185043_a(ChiseledMe.ns("recalibrator_type"), (stack, worldIn, entityIn) -> {
            int nbtFactor = ItemRecalibrator.getEffectFromStack(stack).type.getFactor();
            if (nbtFactor != 0) {
                return nbtFactor;
            }
            int meta = stack.func_77960_j();
            return meta == 0 ? 0.0f : (meta <= 12 ? -1.0f : 1.0f);
        });
        this.func_185043_a(ChiseledMe.ns("recalibrator_tier"), (stack, worldIn, entityIn) -> {
            int nbtTier = ItemRecalibrator.getEffectFromStack(stack).tier;
            if (nbtTier != 0) {
                return nbtTier;
            }
            int meta = stack.func_77960_j();
            return meta == 0 ? 0.0f : (meta <= 12 ? (float)meta : (float)(meta - 12));
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (source, stack) -> {
            BlockPos at = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
            List list = source.func_82618_k().func_72872_a(Entity.class, new AxisAlignedBB(at));
            if (list.isEmpty()) {
                return stack;
            }
            RecalibrationEffect effect = ItemRecalibrator.getEffectFromStack(stack);
            ItemStack worked = stack.func_77946_l();
            for (Entity entity : list) {
                worked = effect.apply(entity, worked);
            }
            return worked;
        });
    }

    public static RecalibrationEffect getEffectFromStack(ItemStack stack) {
        return RecalibrationEffect.fromNBT(stack.func_77978_p());
    }

    public ItemStack create(RecalibrationType type, byte tier) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("type", (byte)type.getFactor());
        nbt.func_74774_a("tier", tier);
        nbt.func_74768_a("charges", 0);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!Config.allowRecalibratingOtherEntities || !player.func_70093_af()) {
            ItemStack used = ItemRecalibrator.getEffectFromStack(stack).apply((Entity)player, stack.func_77946_l());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)(player.func_184812_l_() ? stack : used));
        }
        double reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d start = player.func_174824_e(1.0f);
        Vec3d dir = player.func_70676_i(1.0f).func_186678_a(reach);
        Vec3d end = start.func_178787_e(dir);
        Entity match = null;
        double maxDistSq = reach * reach;
        for (Entity entity : world.func_72839_b((Entity)player, new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c))) {
            double distSq;
            RayTraceResult result;
            if (entity.func_82150_aj()) continue;
            AxisAlignedBB aabb = entity.func_174813_aQ();
            if (entityItemBBoxOffset && entity instanceof EntityItem) {
                double h = aabb.field_72337_e - aabb.field_72338_b;
                aabb = new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b + h, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e + h, aabb.field_72334_f);
            }
            if ((result = aabb.func_72327_a(start, end)) == null || !((distSq = start.func_72436_e(result.field_72307_f)) < maxDistSq)) continue;
            maxDistSq = distSq;
            match = entity;
        }
        if (match != null && (Config.allowRecalibratingOtherPlayers || !(match instanceof EntityPlayer))) {
            ItemStack used = ItemRecalibrator.getEffectFromStack(stack).apply(match, stack.func_77946_l());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)(player.func_184812_l_() ? stack : used));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return ItemRecalibrator.getEffectFromStack(stack).getDisplayString("name");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        RecalibrationEffect effect = ItemRecalibrator.getEffectFromStack(stack);
        tooltip.add(effect.getDisplayString("tooltip"));
        String uses = effect.getChargesLeft();
        if (uses != null) {
            tooltip.add(uses);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        RecalibrationEffect effect = ItemRecalibrator.getEffectFromStack(stack);
        return effect.type == RecalibrationType.RESET ? EnumRarity.UNCOMMON : (effect.tier <= (effect.type == RecalibrationType.REDUCTION ? 8 : 2) ? EnumRarity.RARE : EnumRarity.EPIC);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemRecalibrator.getEffectFromStack(stack).showBar();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ItemRecalibrator.getEffectFromStack(stack).getBar();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        super.func_150895_a(tab, items);
        if (this.func_194125_a(tab)) {
            byte i;
            for (i = 1; i <= 12; i = (byte)(i + 1)) {
                items.add((Object)this.create(RecalibrationType.REDUCTION, i));
            }
            for (i = 1; i <= 4; i = (byte)(i + 1)) {
                items.add((Object)this.create(RecalibrationType.AMPLIFICATION, i));
            }
        }
    }

    public static class RecalibrationEffect {
        private final RecalibrationType type;
        private final int tier;
        private final int charges;
        private final float size;
        private final float maxCharges;

        public static RecalibrationEffect fromNBT(@Nullable NBTTagCompound nbt) {
            int charges;
            byte tier;
            RecalibrationType type;
            if (nbt != null && (type = RecalibrationType.fromFactor(nbt.func_74771_c("type"))) != RecalibrationType.RESET && (tier = nbt.func_74771_c("tier")) > 0 && tier <= type.getMaxTier() && (charges = nbt.func_74762_e("charges")) >= 0) {
                return new RecalibrationEffect(type, tier, charges);
            }
            return new RecalibrationEffect(RecalibrationType.RESET, 0, 0);
        }

        private RecalibrationEffect(RecalibrationType type, int tier, int charges) {
            this.type = type;
            this.tier = tier;
            this.charges = charges;
            this.size = (float)Math.pow(2.0, tier * type.getFactor());
            this.maxCharges = (float)Math.pow(2.0, type.getMaxTier() - tier + 4);
        }

        public boolean showBar() {
            return this.type != RecalibrationType.RESET && this.charges > 0;
        }

        public double getBar() {
            return (float)this.charges / this.maxCharges;
        }

        public String getChargesLeft() {
            if (this.type == RecalibrationType.RESET) {
                return null;
            }
            return SidedHandler.instance.getLocalization("item.chiseled_me:recalibrator.charges", (int)(this.maxCharges - (float)this.charges));
        }

        public String getDisplayString(String sub) {
            int s = (int)(this.type == RecalibrationType.REDUCTION ? 1.0f / this.size : this.size);
            String name = this.type.name().toLowerCase();
            return SidedHandler.instance.getLocalization("item.chiseled_me:recalibrator." + name + "." + sub, s);
        }

        public ItemStack apply(Entity entity, ItemStack stack) {
            boolean isPlayer = entity instanceof EntityPlayer;
            int i = isPlayer ? 1 : 2;
            IRenderSized sized = (IRenderSized)entity;
            double currentSize = sized.getSizeCM();
            if ((double)this.size != currentSize) {
                if (!entity.field_70170_p.field_72995_K) {
                    sized.setSizeCM(this.size, ChangingSizeProcess.log2LerpTime(currentSize, this.size));
                }
                if (isPlayer) {
                    SizeTrigger.INSTANCE.trigger((EntityPlayer)entity, currentSize, this.size);
                } else {
                    i *= 4;
                }
            }
            if (this.type == RecalibrationType.RESET) {
                return stack;
            }
            if ((float)this.charges < this.maxCharges - (float)i) {
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                }
                nbt.func_74768_a("charges", this.charges + i);
                stack.func_77982_d(nbt);
            } else {
                EntityPlayerMP player;
                stack.func_77982_d(null);
                if (entity instanceof EntityPlayerMP && !(player = (EntityPlayerMP)entity).func_184812_l_()) {
                    AdvancementTriggers.RECALIBRATOR_RESET.trigger((EntityPlayer)player);
                }
            }
            return stack;
        }
    }

    public static enum RecalibrationType {
        REDUCTION(-1, 12),
        RESET(0, 0),
        AMPLIFICATION(1, 4);

        private final int factor;
        private final int maxTier;

        private RecalibrationType(int factor, int maxTier) {
            this.factor = factor;
            this.maxTier = maxTier;
        }

        public int getFactor() {
            return this.factor;
        }

        public int getMaxTier() {
            return this.maxTier;
        }

        static RecalibrationType fromFactor(int factor) {
            switch (factor) {
                case -1: {
                    return REDUCTION;
                }
                case 1: {
                    return AMPLIFICATION;
                }
            }
            return RESET;
        }
    }
}

