/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.mixin;

import dev.necauqua.mods.cm.api.IWorldPreciseEvents;
import dev.necauqua.mods.cm.api.IWorldPreciseSounds;
import dev.necauqua.mods.cm.mixin.WorldMixin;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ReportedException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={WorldServer.class})
public abstract class WorldServerMixin
extends WorldMixin
implements IWorldPreciseEvents,
IWorldPreciseSounds {
    @Override
    public void playEvent(EntityPlayer player, int type, BlockPos blockPos, int data, double size, Vec3d pos) {
        try {
            for (IWorldEventListener listener : this.field_73021_x) {
                if (!(listener instanceof IWorldPreciseEvents)) continue;
                ((IWorldPreciseEvents)listener).playEvent(null, type, blockPos, data, size, pos);
            }
        }
        catch (Throwable e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)"Playing level event");
            CrashReportCategory crashreportcategory3 = report.func_85058_a("Level event being played");
            crashreportcategory3.func_71507_a("Block coordinates", (Object)CrashReportCategory.func_180522_a((BlockPos)blockPos));
            crashreportcategory3.func_71507_a("Event source", null);
            crashreportcategory3.func_71507_a("Event type", (Object)type);
            crashreportcategory3.func_71507_a("Event data", (Object)data);
            throw new ReportedException(report);
        }
    }

    @Override
    public void playSound(Vec3d pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay, double size) {
    }

    @Override
    public void playSound(@Nullable EntityPlayer player, Vec3d pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch, double size) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)player, (SoundEvent)soundIn, (SoundCategory)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = event.getSound();
        category = event.getCategory();
        volume = event.getVolume();
        pitch = event.getPitch();
        for (IWorldEventListener listener : this.field_73021_x) {
            if (!(listener instanceof IWorldPreciseEvents)) continue;
            ((IWorldPreciseSounds)listener).playSound(player, pos, soundIn, category, volume, pitch, size);
        }
    }
}

