/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.shared.block.clouds;

import com.progwml6.natura.library.NaturaRegistry;
import com.progwml6.natura.shared.NaturaCommons;
import java.util.Locale;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;

public class BlockCloud
extends EnumBlock<CloudType> {
    public static PropertyEnum<CloudType> TYPE = PropertyEnum.func_177709_a((String)"type", CloudType.class);

    public BlockCloud() {
        super(NaturaRegistry.cloud, TYPE, CloudType.class);
        this.func_149647_a((CreativeTabs)NaturaRegistry.tabWorld);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185854_g);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        EntityArrow entityarrow;
        if (state.func_177229_b(TYPE) == CloudType.SULFUR && entityIn instanceof EntityArrow && !worldIn.field_72995_K && (entityarrow = (EntityArrow)entityIn).func_70027_ad()) {
            this.explode(worldIn, pos, 1, (EntityLivingBase)(entityarrow.field_70250_c instanceof EntityLiving ? (EntityLiving)entityarrow.field_70250_c : null));
            worldIn.func_175698_g(pos);
            return;
        }
        if (entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x *= 0.005;
        }
        entityIn.field_70143_R = 0.0f;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        if (!itemstack.func_190926_b() && state.func_177229_b(TYPE) == CloudType.SULFUR && itemstack.func_77973_b() != Items.field_190931_a && itemstack.func_77973_b() == Items.field_151033_d) {
            worldIn.func_175698_g(pos);
            this.explode(worldIn, pos, 1, (EntityLivingBase)playerIn);
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
    }

    public void explode(World world, BlockPos pos, int size, EntityLivingBase living) {
        world.func_72876_a((Entity)living, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)size, true);
    }

    public boolean func_149659_a(Explosion par1Explosion) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_185904_a() == this.field_149764_J ? false : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        Material material = world.func_180495_p(pos).func_185904_a();
        return material == this.field_149764_J ? false : super.isNormalCube(state, world, pos);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == NaturaCommons.clouds) {
            return null;
        }
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 0.0625, (double)pos.func_177952_p() + 1.0);
    }

    public static enum CloudType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        WHITE,
        DARK,
        ASH,
        SULFUR;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

