/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world;

import com.google.common.eventbus.Subscribe;
import com.progwml6.natura.common.CommonProxy;
import com.progwml6.natura.common.NaturaPulse;
import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.library.Util;
import com.progwml6.natura.world.worldgen.CloudGenerator;
import com.progwml6.natura.world.worldgen.CropGenerator;
import com.progwml6.natura.world.worldgen.GlowshroomGenerator;
import com.progwml6.natura.world.worldgen.NetherBerryBushesGenerator;
import com.progwml6.natura.world.worldgen.NetherMinableGenerator;
import com.progwml6.natura.world.worldgen.NetherTreesGenerator;
import com.progwml6.natura.world.worldgen.OverworldBerryBushesGenerator;
import com.progwml6.natura.world.worldgen.OverworldTreesGenerator;
import com.progwml6.natura.world.worldgen.VineGenerator;
import com.progwml6.natura.world.worldgen.retrogen.TickHandlerWorldRetrogen;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="NaturaWorld", description="Everything that's found in the world and worldgen including the netherite dimension")
public class NaturaWorld
extends NaturaPulse {
    public static final String PulseId = "NaturaWorld";
    static final Logger log = Util.getLogger("NaturaWorld");
    @SidedProxy(clientSide="com.progwml6.natura.world.WorldClientProxy", serverSide="com.progwml6.natura.common.CommonProxy")
    public static CommonProxy proxy;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        if (NaturaWorld.isOverworldLoaded()) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)OverworldTreesGenerator.INSTANCE, (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)OverworldBerryBushesGenerator.INSTANCE, (int)0);
            if (Config.enableCloudBlocks) {
                GameRegistry.registerWorldGenerator((IWorldGenerator)CloudGenerator.INSTANCE, (int)0);
            }
            GameRegistry.registerWorldGenerator((IWorldGenerator)CropGenerator.INSTANCE, (int)0);
        }
        if (NaturaWorld.isNetherLoaded()) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)NetherTreesGenerator.INSTANCE, (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)NetherBerryBushesGenerator.INSTANCE, (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)GlowshroomGenerator.INSTANCE, (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)VineGenerator.INSTANCE, (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)NetherMinableGenerator.INSTANCE, (int)0);
        }
        MinecraftForge.EVENT_BUS.register((Object)TickHandlerWorldRetrogen.INSTANCE);
        proxy.postInit();
    }
}

