/*
 * Decompiled with CFR 0.152.
 */
package uk.binarycraft.journeymapdefaults;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import uk.binarycraft.journeymapdefaults.proxies.CommonProxy;

@Mod(modid="journeymapdefaults", version="1.12-0.0.2", acceptedMinecraftVersions="[1.12.2]")
public class JourneyMapDefaults {
    public static final String MODID = "journeymapdefaults";
    public static final String VERSION = "1.12-0.0.2";
    public static final String ACCEPTED_MINECRAFT_VERSIONS = "[1.12.2]";
    public static String journeyMapConfigDir;
    public static boolean onlyCreateConfigOnFirstRun;
    public static String firstRunFile;
    public static String forgeConfigDirectory;
    public static String journeyMapDefaultsConfigDirectory;
    public static String instanceRootDirectory;
    @SidedProxy(clientSide="uk.binarycraft.journeymapdefaults.proxies.ClientProxy", serverSide="uk.binarycraft.journeymapdefaults.proxies.ServerProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws Exception {
        this.getConfiguration(event);
        forgeConfigDirectory = event.getModConfigurationDirectory().getAbsolutePath() + "/";
        journeyMapDefaultsConfigDirectory = forgeConfigDirectory + "JourneyMapDefaults/";
        instanceRootDirectory = event.getModConfigurationDirectory().getParent() + "/";
        proxy.preInit(event);
    }

    private void getConfiguration(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        journeyMapConfigDir = config.getString("JourneyMapConfigDir", "general", "journeymap/config/5.5", "This is the path to the Journey map configuration directory, relative to the minecraft instance folder. In most cases, this will be 'journeymap/config/5.5'");
        onlyCreateConfigOnFirstRun = config.getBoolean("OnlyCreateConfigOnFirstRun", "general", true, "This setting should always be true. If you deploy your mod pack with this set to false, you will upset users, as their own preferences for JourneyMap will be overwritten by your defaults every time they launch your modpack. Players, if you find this setting set to false, and you're losing your JourneyMap settings, please take it up with the modpack maker, not me!");
        firstRunFile = config.getString("JourneyMapFirstRunFile", "general", "journeymapdefaults.firstrun", "There is normally no need to change this setting. This is a file created by this mod, on first run. If this file exists when the mod is loaded, this mod will not attempt to overwrite any existing JourneyMap configuration files.");
        config.save();
    }
}

